/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.linecorp.bot.messaging.model.Action;
import com.linecorp.bot.messaging.model.FlexComponent;

@JsonTypeName(value="button")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record FlexButton(@JsonProperty(value="flex") Integer flex, @JsonProperty(value="color") String color, @JsonProperty(value="style") Style style, @JsonProperty(value="action") Action action, @JsonProperty(value="gravity") Gravity gravity, @JsonProperty(value="margin") String margin, @JsonProperty(value="position") Position position, @JsonProperty(value="offsetTop") String offsetTop, @JsonProperty(value="offsetBottom") String offsetBottom, @JsonProperty(value="offsetStart") String offsetStart, @JsonProperty(value="offsetEnd") String offsetEnd, @JsonProperty(value="height") Height height, @JsonProperty(value="adjustMode") AdjustMode adjustMode, @JsonProperty(value="scaling") Boolean scaling) implements FlexComponent
{

    public static enum Style {
        PRIMARY,
        SECONDARY,
        LINK,
        UNDEFINED;

    }

    public static enum Gravity {
        TOP,
        BOTTOM,
        CENTER,
        UNDEFINED;

    }

    public static enum Position {
        RELATIVE,
        ABSOLUTE,
        UNDEFINED;

    }

    public static enum Height {
        MD,
        SM,
        UNDEFINED;

    }

    public static enum AdjustMode {
        SHRINK_TO_FIT,
        UNDEFINED;

    }

    public static class Builder {
        private Integer flex;
        private String color;
        private Style style;
        private Action action;
        private Gravity gravity;
        private String margin;
        private Position position;
        private String offsetTop;
        private String offsetBottom;
        private String offsetStart;
        private String offsetEnd;
        private Height height;
        private AdjustMode adjustMode;
        private Boolean scaling;

        public Builder(Action action) {
            this.action = action;
        }

        public Builder flex(Integer flex) {
            this.flex = flex;
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            return this;
        }

        public Builder style(Style style) {
            this.style = style;
            return this;
        }

        public Builder gravity(Gravity gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder margin(String margin) {
            this.margin = margin;
            return this;
        }

        public Builder position(Position position) {
            this.position = position;
            return this;
        }

        public Builder offsetTop(String offsetTop) {
            this.offsetTop = offsetTop;
            return this;
        }

        public Builder offsetBottom(String offsetBottom) {
            this.offsetBottom = offsetBottom;
            return this;
        }

        public Builder offsetStart(String offsetStart) {
            this.offsetStart = offsetStart;
            return this;
        }

        public Builder offsetEnd(String offsetEnd) {
            this.offsetEnd = offsetEnd;
            return this;
        }

        public Builder height(Height height) {
            this.height = height;
            return this;
        }

        public Builder adjustMode(AdjustMode adjustMode) {
            this.adjustMode = adjustMode;
            return this;
        }

        public Builder scaling(Boolean scaling) {
            this.scaling = scaling;
            return this;
        }

        public FlexButton build() {
            return new FlexButton(this.flex, this.color, this.style, this.action, this.gravity, this.margin, this.position, this.offsetTop, this.offsetBottom, this.offsetStart, this.offsetEnd, this.height, this.adjustMode, this.scaling);
        }
    }
}

