/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.linecorp.bot.messaging.model.FlexComponent;
import java.net.URI;

@JsonTypeName(value="icon")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record FlexIcon(@JsonProperty(value="url") URI url, @JsonProperty(value="size") String size, @JsonProperty(value="aspectRatio") String aspectRatio, @JsonProperty(value="margin") String margin, @JsonProperty(value="position") Position position, @JsonProperty(value="offsetTop") String offsetTop, @JsonProperty(value="offsetBottom") String offsetBottom, @JsonProperty(value="offsetStart") String offsetStart, @JsonProperty(value="offsetEnd") String offsetEnd, @JsonProperty(value="scaling") Boolean scaling) implements FlexComponent
{

    public static enum Position {
        RELATIVE,
        ABSOLUTE,
        UNDEFINED;

    }

    public static class Builder {
        private URI url;
        private String size;
        private String aspectRatio;
        private String margin;
        private Position position;
        private String offsetTop;
        private String offsetBottom;
        private String offsetStart;
        private String offsetEnd;
        private Boolean scaling;

        public Builder(URI url) {
            this.url = url;
        }

        public Builder size(String size) {
            this.size = size;
            return this;
        }

        public Builder aspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public Builder margin(String margin) {
            this.margin = margin;
            return this;
        }

        public Builder position(Position position) {
            this.position = position;
            return this;
        }

        public Builder offsetTop(String offsetTop) {
            this.offsetTop = offsetTop;
            return this;
        }

        public Builder offsetBottom(String offsetBottom) {
            this.offsetBottom = offsetBottom;
            return this;
        }

        public Builder offsetStart(String offsetStart) {
            this.offsetStart = offsetStart;
            return this;
        }

        public Builder offsetEnd(String offsetEnd) {
            this.offsetEnd = offsetEnd;
            return this;
        }

        public Builder scaling(Boolean scaling) {
            this.scaling = scaling;
            return this;
        }

        public FlexIcon build() {
            return new FlexIcon(this.url, this.size, this.aspectRatio, this.margin, this.position, this.offsetTop, this.offsetBottom, this.offsetStart, this.offsetEnd, this.scaling);
        }
    }
}

