/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.linecorp.bot.messaging.model.Action;
import com.linecorp.bot.messaging.model.FlexComponent;
import java.net.URI;

@JsonTypeName(value="image")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record FlexImage(@JsonProperty(value="url") URI url, @JsonProperty(value="flex") Integer flex, @JsonProperty(value="margin") String margin, @JsonProperty(value="position") Position position, @JsonProperty(value="offsetTop") String offsetTop, @JsonProperty(value="offsetBottom") String offsetBottom, @JsonProperty(value="offsetStart") String offsetStart, @JsonProperty(value="offsetEnd") String offsetEnd, @JsonProperty(value="align") Align align, @JsonProperty(value="gravity") Gravity gravity, @JsonProperty(value="size") String size, @JsonProperty(value="aspectRatio") String aspectRatio, @JsonProperty(value="aspectMode") AspectMode aspectMode, @JsonProperty(value="backgroundColor") String backgroundColor, @JsonProperty(value="action") Action action, @JsonProperty(value="animated") Boolean animated) implements FlexComponent
{

    public static enum Position {
        RELATIVE,
        ABSOLUTE,
        UNDEFINED;

    }

    public static enum Align {
        START,
        END,
        CENTER,
        UNDEFINED;

    }

    public static enum Gravity {
        TOP,
        BOTTOM,
        CENTER,
        UNDEFINED;

    }

    public static enum AspectMode {
        FIT,
        COVER,
        UNDEFINED;

    }

    public static class Builder {
        private URI url;
        private Integer flex;
        private String margin;
        private Position position;
        private String offsetTop;
        private String offsetBottom;
        private String offsetStart;
        private String offsetEnd;
        private Align align;
        private Gravity gravity;
        private String size;
        private String aspectRatio;
        private AspectMode aspectMode;
        private String backgroundColor;
        private Action action;
        private Boolean animated;

        public Builder(URI url) {
            this.url = url;
        }

        public Builder flex(Integer flex) {
            this.flex = flex;
            return this;
        }

        public Builder margin(String margin) {
            this.margin = margin;
            return this;
        }

        public Builder position(Position position) {
            this.position = position;
            return this;
        }

        public Builder offsetTop(String offsetTop) {
            this.offsetTop = offsetTop;
            return this;
        }

        public Builder offsetBottom(String offsetBottom) {
            this.offsetBottom = offsetBottom;
            return this;
        }

        public Builder offsetStart(String offsetStart) {
            this.offsetStart = offsetStart;
            return this;
        }

        public Builder offsetEnd(String offsetEnd) {
            this.offsetEnd = offsetEnd;
            return this;
        }

        public Builder align(Align align) {
            this.align = align;
            return this;
        }

        public Builder gravity(Gravity gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder size(String size) {
            this.size = size;
            return this;
        }

        public Builder aspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public Builder aspectMode(AspectMode aspectMode) {
            this.aspectMode = aspectMode;
            return this;
        }

        public Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            return this;
        }

        public Builder animated(Boolean animated) {
            this.animated = animated;
            return this;
        }

        public FlexImage build() {
            return new FlexImage(this.url, this.flex, this.margin, this.position, this.offsetTop, this.offsetBottom, this.offsetStart, this.offsetEnd, this.align, this.gravity, this.size, this.aspectRatio, this.aspectMode, this.backgroundColor, this.action, this.animated);
        }
    }
}

