/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.linecorp.bot.messaging.model.Message;
import com.linecorp.bot.messaging.model.QuickReply;
import com.linecorp.bot.messaging.model.Sender;
import java.net.URI;

@JsonTypeName(value="image")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record ImageMessage(@JsonProperty(value="quickReply") QuickReply quickReply, @JsonProperty(value="sender") Sender sender, @JsonProperty(value="originalContentUrl") URI originalContentUrl, @JsonProperty(value="previewImageUrl") URI previewImageUrl) implements Message
{
    public ImageMessage(URI originalContentUrl, URI previewImageUrl) {
        this(null, null, originalContentUrl, previewImageUrl);
    }

    public static class Builder {
        private QuickReply quickReply;
        private Sender sender;
        private URI originalContentUrl;
        private URI previewImageUrl;

        public Builder(URI originalContentUrl, URI previewImageUrl) {
            this.originalContentUrl = originalContentUrl;
            this.previewImageUrl = previewImageUrl;
        }

        public Builder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        public Builder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        public ImageMessage build() {
            return new ImageMessage(this.quickReply, this.sender, this.originalContentUrl, this.previewImageUrl);
        }
    }
}

