/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.linecorp.bot.messaging.model.ImagemapAction;
import com.linecorp.bot.messaging.model.ImagemapBaseSize;
import com.linecorp.bot.messaging.model.ImagemapVideo;
import com.linecorp.bot.messaging.model.Message;
import com.linecorp.bot.messaging.model.QuickReply;
import com.linecorp.bot.messaging.model.Sender;
import java.net.URI;
import java.util.List;

@JsonTypeName(value="imagemap")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record ImagemapMessage(@JsonProperty(value="quickReply") QuickReply quickReply, @JsonProperty(value="sender") Sender sender, @JsonProperty(value="baseUrl") URI baseUrl, @JsonProperty(value="altText") String altText, @JsonProperty(value="baseSize") ImagemapBaseSize baseSize, @JsonProperty(value="actions") List<ImagemapAction> actions, @JsonProperty(value="video") ImagemapVideo video) implements Message
{

    public static class Builder {
        private QuickReply quickReply;
        private Sender sender;
        private URI baseUrl;
        private String altText;
        private ImagemapBaseSize baseSize;
        private List<ImagemapAction> actions;
        private ImagemapVideo video;

        public Builder(URI baseUrl, String altText, ImagemapBaseSize baseSize, List<ImagemapAction> actions) {
            this.baseUrl = baseUrl;
            this.altText = altText;
            this.baseSize = baseSize;
            this.actions = actions;
        }

        public Builder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        public Builder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        public Builder video(ImagemapVideo video) {
            this.video = video;
            return this;
        }

        public ImagemapMessage build() {
            return new ImagemapMessage(this.quickReply, this.sender, this.baseUrl, this.altText, this.baseSize, this.actions, this.video);
        }
    }
}

