/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record NarrowcastProgressResponse(@JsonProperty(value="phase") Phase phase, @JsonProperty(value="successCount") Long successCount, @JsonProperty(value="failureCount") Long failureCount, @JsonProperty(value="targetCount") Long targetCount, @JsonProperty(value="failedDescription") String failedDescription, @JsonProperty(value="errorCode") Long errorCode, @JsonProperty(value="acceptedTime") OffsetDateTime acceptedTime, @JsonProperty(value="completedTime") OffsetDateTime completedTime) {

    public static enum Phase {
        WAITING,
        SENDING,
        SUCCEEDED,
        FAILED,
        UNDEFINED;

    }

    public static class Builder {
        private Phase phase;
        private Long successCount;
        private Long failureCount;
        private Long targetCount;
        private String failedDescription;
        private Long errorCode;
        private OffsetDateTime acceptedTime;
        private OffsetDateTime completedTime;

        public Builder(Phase phase, OffsetDateTime acceptedTime) {
            this.phase = phase;
            this.acceptedTime = acceptedTime;
        }

        public Builder successCount(Long successCount) {
            this.successCount = successCount;
            return this;
        }

        public Builder failureCount(Long failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        public Builder targetCount(Long targetCount) {
            this.targetCount = targetCount;
            return this;
        }

        public Builder failedDescription(String failedDescription) {
            this.failedDescription = failedDescription;
            return this;
        }

        public Builder errorCode(Long errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder completedTime(OffsetDateTime completedTime) {
            this.completedTime = completedTime;
            return this;
        }

        public NarrowcastProgressResponse build() {
            return new NarrowcastProgressResponse(this.phase, this.successCount, this.failureCount, this.targetCount, this.failedDescription, this.errorCode, this.acceptedTime, this.completedTime);
        }
    }
}

