/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.messaging.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.linecorp.bot.messaging.model.Emoji;
import com.linecorp.bot.messaging.model.Message;
import com.linecorp.bot.messaging.model.QuickReply;
import com.linecorp.bot.messaging.model.Sender;
import java.util.List;

@JsonTypeName(value="text")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record TextMessage(@JsonProperty(value="quickReply") QuickReply quickReply, @JsonProperty(value="sender") Sender sender, @JsonProperty(value="text") String text, @JsonProperty(value="emojis") List<Emoji> emojis, @JsonProperty(value="quoteToken") String quoteToken) implements Message
{
    public TextMessage(String text) {
        this(null, null, text, null, null);
    }

    public static class Builder {
        private QuickReply quickReply;
        private Sender sender;
        private String text;
        private List<Emoji> emojis;
        private String quoteToken;

        public Builder(String text) {
            this.text = text;
        }

        public Builder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        public Builder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        public Builder emojis(List<Emoji> emojis) {
            this.emojis = emojis;
            return this;
        }

        public Builder quoteToken(String quoteToken) {
            this.quoteToken = quoteToken;
            return this;
        }

        public TextMessage build() {
            return new TextMessage(this.quickReply, this.sender, this.text, this.emojis, this.quoteToken);
        }
    }
}

