/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.action;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.linecorp.bot.internal.DatetimePickerFieldSerializer;
import com.linecorp.bot.model.action.Action;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;

@JsonTypeName(value="datetimepicker")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public interface DatetimePickerAction<T extends Temporal>
extends Action {
    @Override
    public String getLabel();

    public String getData();

    public Mode getMode();

    @JsonSerialize(using=DatetimePickerFieldSerializer.class)
    public T getInitial();

    @JsonSerialize(using=DatetimePickerFieldSerializer.class)
    public T getMax();

    @JsonSerialize(using=DatetimePickerFieldSerializer.class)
    public T getMin();

    @JsonCreator
    @Deprecated
    public static DatetimePickerAction<?> parse(@JsonProperty(value="label") String label, @JsonProperty(value="data") String data, @JsonProperty(value="mode") Mode mode, @JsonProperty(value="initial") String initial, @JsonProperty(value="max") String max, @JsonProperty(value="min") String min) {
        switch (mode) {
            case DATE: {
                return OfLocalDate.builder().label(label).data(data).initial(initial != null ? LocalDate.parse(initial) : null).max(initial != null ? LocalDate.parse(max) : null).min(initial != null ? LocalDate.parse(min) : null).build();
            }
            case TIME: {
                return OfLocalTime.builder().label(label).data(data).initial(initial != null ? LocalTime.parse(initial) : null).max(initial != null ? LocalTime.parse(max) : null).min(initial != null ? LocalTime.parse(min) : null).build();
            }
            case DATETIME: {
                return OfLocalDatetime.builder().label(label).data(data).initial(initial != null ? LocalDateTime.parse(initial) : null).max(initial != null ? LocalDateTime.parse(max) : null).min(initial != null ? LocalDateTime.parse(min) : null).build();
            }
        }
        throw new UnsupportedOperationException("Unknown mode: " + (Object)((Object)mode));
    }

    public static final class OfLocalDatetime
    implements DatetimePickerAction<LocalDateTime> {
        private final String label;
        private final String data;
        private final LocalDateTime initial;
        private final LocalDateTime min;
        private final LocalDateTime max;

        @Override
        public Mode getMode() {
            return Mode.DATETIME;
        }

        OfLocalDatetime(String label, String data, LocalDateTime initial, LocalDateTime min, LocalDateTime max) {
            this.label = label;
            this.data = data;
            this.initial = initial;
            this.min = min;
            this.max = max;
        }

        public static OfLocalDatetimeBuilder builder() {
            return new OfLocalDatetimeBuilder();
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public LocalDateTime getInitial() {
            return this.initial;
        }

        @Override
        public LocalDateTime getMin() {
            return this.min;
        }

        @Override
        public LocalDateTime getMax() {
            return this.max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OfLocalDatetime)) {
                return false;
            }
            OfLocalDatetime other = (OfLocalDatetime)o;
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            LocalDateTime this$initial = this.getInitial();
            LocalDateTime other$initial = other.getInitial();
            if (this$initial == null ? other$initial != null : !((Object)this$initial).equals(other$initial)) {
                return false;
            }
            LocalDateTime this$min = this.getMin();
            LocalDateTime other$min = other.getMin();
            if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                return false;
            }
            LocalDateTime this$max = this.getMax();
            LocalDateTime other$max = other.getMax();
            return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            LocalDateTime $initial = this.getInitial();
            result = result * 59 + ($initial == null ? 43 : ((Object)$initial).hashCode());
            LocalDateTime $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
            LocalDateTime $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
            return result;
        }

        public String toString() {
            return "DatetimePickerAction.OfLocalDatetime(label=" + this.getLabel() + ", data=" + this.getData() + ", initial=" + this.getInitial() + ", min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }

        public static class OfLocalDatetimeBuilder {
            private String label;
            private String data;
            private LocalDateTime initial;
            private LocalDateTime min;
            private LocalDateTime max;

            OfLocalDatetimeBuilder() {
            }

            public OfLocalDatetimeBuilder label(String label) {
                this.label = label;
                return this;
            }

            public OfLocalDatetimeBuilder data(String data) {
                this.data = data;
                return this;
            }

            public OfLocalDatetimeBuilder initial(LocalDateTime initial) {
                this.initial = initial;
                return this;
            }

            public OfLocalDatetimeBuilder min(LocalDateTime min) {
                this.min = min;
                return this;
            }

            public OfLocalDatetimeBuilder max(LocalDateTime max) {
                this.max = max;
                return this;
            }

            public OfLocalDatetime build() {
                return new OfLocalDatetime(this.label, this.data, this.initial, this.min, this.max);
            }

            public String toString() {
                return "DatetimePickerAction.OfLocalDatetime.OfLocalDatetimeBuilder(label=" + this.label + ", data=" + this.data + ", initial=" + this.initial + ", min=" + this.min + ", max=" + this.max + ")";
            }
        }
    }

    public static final class OfLocalTime
    implements DatetimePickerAction<LocalTime> {
        private final String label;
        private final String data;
        private final LocalTime initial;
        private final LocalTime min;
        private final LocalTime max;

        @Override
        public Mode getMode() {
            return Mode.TIME;
        }

        OfLocalTime(String label, String data, LocalTime initial, LocalTime min, LocalTime max) {
            this.label = label;
            this.data = data;
            this.initial = initial;
            this.min = min;
            this.max = max;
        }

        public static OfLocalTimeBuilder builder() {
            return new OfLocalTimeBuilder();
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public LocalTime getInitial() {
            return this.initial;
        }

        @Override
        public LocalTime getMin() {
            return this.min;
        }

        @Override
        public LocalTime getMax() {
            return this.max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OfLocalTime)) {
                return false;
            }
            OfLocalTime other = (OfLocalTime)o;
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            LocalTime this$initial = this.getInitial();
            LocalTime other$initial = other.getInitial();
            if (this$initial == null ? other$initial != null : !((Object)this$initial).equals(other$initial)) {
                return false;
            }
            LocalTime this$min = this.getMin();
            LocalTime other$min = other.getMin();
            if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                return false;
            }
            LocalTime this$max = this.getMax();
            LocalTime other$max = other.getMax();
            return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            LocalTime $initial = this.getInitial();
            result = result * 59 + ($initial == null ? 43 : ((Object)$initial).hashCode());
            LocalTime $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
            LocalTime $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
            return result;
        }

        public String toString() {
            return "DatetimePickerAction.OfLocalTime(label=" + this.getLabel() + ", data=" + this.getData() + ", initial=" + this.getInitial() + ", min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }

        public static class OfLocalTimeBuilder {
            private String label;
            private String data;
            private LocalTime initial;
            private LocalTime min;
            private LocalTime max;

            OfLocalTimeBuilder() {
            }

            public OfLocalTimeBuilder label(String label) {
                this.label = label;
                return this;
            }

            public OfLocalTimeBuilder data(String data) {
                this.data = data;
                return this;
            }

            public OfLocalTimeBuilder initial(LocalTime initial) {
                this.initial = initial;
                return this;
            }

            public OfLocalTimeBuilder min(LocalTime min) {
                this.min = min;
                return this;
            }

            public OfLocalTimeBuilder max(LocalTime max) {
                this.max = max;
                return this;
            }

            public OfLocalTime build() {
                return new OfLocalTime(this.label, this.data, this.initial, this.min, this.max);
            }

            public String toString() {
                return "DatetimePickerAction.OfLocalTime.OfLocalTimeBuilder(label=" + this.label + ", data=" + this.data + ", initial=" + this.initial + ", min=" + this.min + ", max=" + this.max + ")";
            }
        }
    }

    public static final class OfLocalDate
    implements DatetimePickerAction<LocalDate> {
        private final String label;
        private final String data;
        private final LocalDate initial;
        private final LocalDate min;
        private final LocalDate max;

        @Override
        public Mode getMode() {
            return Mode.DATE;
        }

        OfLocalDate(String label, String data, LocalDate initial, LocalDate min, LocalDate max) {
            this.label = label;
            this.data = data;
            this.initial = initial;
            this.min = min;
            this.max = max;
        }

        public static OfLocalDateBuilder builder() {
            return new OfLocalDateBuilder();
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public LocalDate getInitial() {
            return this.initial;
        }

        @Override
        public LocalDate getMin() {
            return this.min;
        }

        @Override
        public LocalDate getMax() {
            return this.max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OfLocalDate)) {
                return false;
            }
            OfLocalDate other = (OfLocalDate)o;
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            LocalDate this$initial = this.getInitial();
            LocalDate other$initial = other.getInitial();
            if (this$initial == null ? other$initial != null : !((Object)this$initial).equals(other$initial)) {
                return false;
            }
            LocalDate this$min = this.getMin();
            LocalDate other$min = other.getMin();
            if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                return false;
            }
            LocalDate this$max = this.getMax();
            LocalDate other$max = other.getMax();
            return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            LocalDate $initial = this.getInitial();
            result = result * 59 + ($initial == null ? 43 : ((Object)$initial).hashCode());
            LocalDate $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
            LocalDate $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
            return result;
        }

        public String toString() {
            return "DatetimePickerAction.OfLocalDate(label=" + this.getLabel() + ", data=" + this.getData() + ", initial=" + this.getInitial() + ", min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }

        public static class OfLocalDateBuilder {
            private String label;
            private String data;
            private LocalDate initial;
            private LocalDate min;
            private LocalDate max;

            OfLocalDateBuilder() {
            }

            public OfLocalDateBuilder label(String label) {
                this.label = label;
                return this;
            }

            public OfLocalDateBuilder data(String data) {
                this.data = data;
                return this;
            }

            public OfLocalDateBuilder initial(LocalDate initial) {
                this.initial = initial;
                return this;
            }

            public OfLocalDateBuilder min(LocalDate min) {
                this.min = min;
                return this;
            }

            public OfLocalDateBuilder max(LocalDate max) {
                this.max = max;
                return this;
            }

            public OfLocalDate build() {
                return new OfLocalDate(this.label, this.data, this.initial, this.min, this.max);
            }

            public String toString() {
                return "DatetimePickerAction.OfLocalDate.OfLocalDateBuilder(label=" + this.label + ", data=" + this.data + ", initial=" + this.initial + ", min=" + this.min + ", max=" + this.max + ")";
            }
        }
    }

    public static enum Mode {
        DATE,
        TIME,
        DATETIME;

    }
}

