/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.message.Message;
import com.linecorp.bot.model.message.quickreply.QuickReply;
import java.net.URI;

@JsonTypeName(value="audio")
@JsonDeserialize(builder=AudioMessageBuilder.class)
public final class AudioMessage
implements Message {
    private final URI originalContentUrl;
    private final Integer duration;
    private final QuickReply quickReply;

    public AudioMessage(URI originalContentUrl, Integer duration) {
        this(originalContentUrl, duration, null);
    }

    public static AudioMessageBuilder builder() {
        return new AudioMessageBuilder();
    }

    public AudioMessageBuilder toBuilder() {
        return new AudioMessageBuilder().originalContentUrl(this.originalContentUrl).duration(this.duration).quickReply(this.quickReply);
    }

    public URI getOriginalContentUrl() {
        return this.originalContentUrl;
    }

    public Integer getDuration() {
        return this.duration;
    }

    @Override
    public QuickReply getQuickReply() {
        return this.quickReply;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioMessage)) {
            return false;
        }
        AudioMessage other = (AudioMessage)o;
        URI this$originalContentUrl = this.getOriginalContentUrl();
        URI other$originalContentUrl = other.getOriginalContentUrl();
        if (this$originalContentUrl == null ? other$originalContentUrl != null : !((Object)this$originalContentUrl).equals(other$originalContentUrl)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        QuickReply this$quickReply = this.getQuickReply();
        QuickReply other$quickReply = other.getQuickReply();
        return !(this$quickReply == null ? other$quickReply != null : !((Object)this$quickReply).equals(other$quickReply));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $originalContentUrl = this.getOriginalContentUrl();
        result = result * 59 + ($originalContentUrl == null ? 43 : ((Object)$originalContentUrl).hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        QuickReply $quickReply = this.getQuickReply();
        result = result * 59 + ($quickReply == null ? 43 : ((Object)$quickReply).hashCode());
        return result;
    }

    public String toString() {
        return "AudioMessage(originalContentUrl=" + this.getOriginalContentUrl() + ", duration=" + this.getDuration() + ", quickReply=" + this.getQuickReply() + ")";
    }

    private AudioMessage(URI originalContentUrl, Integer duration, QuickReply quickReply) {
        this.originalContentUrl = originalContentUrl;
        this.duration = duration;
        this.quickReply = quickReply;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class AudioMessageBuilder {
        private URI originalContentUrl;
        private Integer duration;
        private QuickReply quickReply;

        AudioMessageBuilder() {
        }

        public AudioMessageBuilder originalContentUrl(URI originalContentUrl) {
            this.originalContentUrl = originalContentUrl;
            return this;
        }

        public AudioMessageBuilder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public AudioMessageBuilder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        public AudioMessage build() {
            return new AudioMessage(this.originalContentUrl, this.duration, this.quickReply);
        }

        public String toString() {
            return "AudioMessage.AudioMessageBuilder(originalContentUrl=" + this.originalContentUrl + ", duration=" + this.duration + ", quickReply=" + this.quickReply + ")";
        }
    }
}

