/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.message.Message;
import com.linecorp.bot.model.message.quickreply.QuickReply;
import java.net.URI;

@JsonTypeName(value="image")
@JsonDeserialize(builder=ImageMessageBuilder.class)
public final class ImageMessage
implements Message {
    private final URI originalContentUrl;
    private final URI previewImageUrl;
    private final QuickReply quickReply;

    public ImageMessage(URI originalContentUrl, URI previewImageUrl) {
        this(originalContentUrl, previewImageUrl, null);
    }

    public static ImageMessageBuilder builder() {
        return new ImageMessageBuilder();
    }

    public ImageMessageBuilder toBuilder() {
        return new ImageMessageBuilder().originalContentUrl(this.originalContentUrl).previewImageUrl(this.previewImageUrl).quickReply(this.quickReply);
    }

    public URI getOriginalContentUrl() {
        return this.originalContentUrl;
    }

    public URI getPreviewImageUrl() {
        return this.previewImageUrl;
    }

    @Override
    public QuickReply getQuickReply() {
        return this.quickReply;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageMessage)) {
            return false;
        }
        ImageMessage other = (ImageMessage)o;
        URI this$originalContentUrl = this.getOriginalContentUrl();
        URI other$originalContentUrl = other.getOriginalContentUrl();
        if (this$originalContentUrl == null ? other$originalContentUrl != null : !((Object)this$originalContentUrl).equals(other$originalContentUrl)) {
            return false;
        }
        URI this$previewImageUrl = this.getPreviewImageUrl();
        URI other$previewImageUrl = other.getPreviewImageUrl();
        if (this$previewImageUrl == null ? other$previewImageUrl != null : !((Object)this$previewImageUrl).equals(other$previewImageUrl)) {
            return false;
        }
        QuickReply this$quickReply = this.getQuickReply();
        QuickReply other$quickReply = other.getQuickReply();
        return !(this$quickReply == null ? other$quickReply != null : !((Object)this$quickReply).equals(other$quickReply));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $originalContentUrl = this.getOriginalContentUrl();
        result = result * 59 + ($originalContentUrl == null ? 43 : ((Object)$originalContentUrl).hashCode());
        URI $previewImageUrl = this.getPreviewImageUrl();
        result = result * 59 + ($previewImageUrl == null ? 43 : ((Object)$previewImageUrl).hashCode());
        QuickReply $quickReply = this.getQuickReply();
        result = result * 59 + ($quickReply == null ? 43 : ((Object)$quickReply).hashCode());
        return result;
    }

    public String toString() {
        return "ImageMessage(originalContentUrl=" + this.getOriginalContentUrl() + ", previewImageUrl=" + this.getPreviewImageUrl() + ", quickReply=" + this.getQuickReply() + ")";
    }

    private ImageMessage(URI originalContentUrl, URI previewImageUrl, QuickReply quickReply) {
        this.originalContentUrl = originalContentUrl;
        this.previewImageUrl = previewImageUrl;
        this.quickReply = quickReply;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class ImageMessageBuilder {
        private URI originalContentUrl;
        private URI previewImageUrl;
        private QuickReply quickReply;

        ImageMessageBuilder() {
        }

        public ImageMessageBuilder originalContentUrl(URI originalContentUrl) {
            this.originalContentUrl = originalContentUrl;
            return this;
        }

        public ImageMessageBuilder previewImageUrl(URI previewImageUrl) {
            this.previewImageUrl = previewImageUrl;
            return this;
        }

        public ImageMessageBuilder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        public ImageMessage build() {
            return new ImageMessage(this.originalContentUrl, this.previewImageUrl, this.quickReply);
        }

        public String toString() {
            return "ImageMessage.ImageMessageBuilder(originalContentUrl=" + this.originalContentUrl + ", previewImageUrl=" + this.previewImageUrl + ", quickReply=" + this.quickReply + ")";
        }
    }
}

