/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.message.Message;
import com.linecorp.bot.model.message.quickreply.QuickReply;

@JsonTypeName(value="location")
@JsonDeserialize(builder=LocationMessageBuilder.class)
public final class LocationMessage
implements Message {
    private final String title;
    private final String address;
    private final double latitude;
    private final double longitude;
    private final QuickReply quickReply;

    public LocationMessage(String title, String address, double latitude, double longitude) {
        this(title, address, latitude, longitude, null);
    }

    public static LocationMessageBuilder builder() {
        return new LocationMessageBuilder();
    }

    public LocationMessageBuilder toBuilder() {
        return new LocationMessageBuilder().title(this.title).address(this.address).latitude(this.latitude).longitude(this.longitude).quickReply(this.quickReply);
    }

    public String getTitle() {
        return this.title;
    }

    public String getAddress() {
        return this.address;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public QuickReply getQuickReply() {
        return this.quickReply;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationMessage)) {
            return false;
        }
        LocationMessage other = (LocationMessage)o;
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        if (Double.compare(this.getLongitude(), other.getLongitude()) != 0) {
            return false;
        }
        QuickReply this$quickReply = this.getQuickReply();
        QuickReply other$quickReply = other.getQuickReply();
        return !(this$quickReply == null ? other$quickReply != null : !((Object)this$quickReply).equals(other$quickReply));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        long $latitude = Double.doubleToLongBits(this.getLatitude());
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = Double.doubleToLongBits(this.getLongitude());
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        QuickReply $quickReply = this.getQuickReply();
        result = result * 59 + ($quickReply == null ? 43 : ((Object)$quickReply).hashCode());
        return result;
    }

    public String toString() {
        return "LocationMessage(title=" + this.getTitle() + ", address=" + this.getAddress() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", quickReply=" + this.getQuickReply() + ")";
    }

    private LocationMessage(String title, String address, double latitude, double longitude, QuickReply quickReply) {
        this.title = title;
        this.address = address;
        this.latitude = latitude;
        this.longitude = longitude;
        this.quickReply = quickReply;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class LocationMessageBuilder {
        private String title;
        private String address;
        private double latitude;
        private double longitude;
        private QuickReply quickReply;

        LocationMessageBuilder() {
        }

        public LocationMessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        public LocationMessageBuilder address(String address) {
            this.address = address;
            return this;
        }

        public LocationMessageBuilder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public LocationMessageBuilder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public LocationMessageBuilder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        public LocationMessage build() {
            return new LocationMessage(this.title, this.address, this.latitude, this.longitude, this.quickReply);
        }

        public String toString() {
            return "LocationMessage.LocationMessageBuilder(title=" + this.title + ", address=" + this.address + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", quickReply=" + this.quickReply + ")";
        }
    }
}

