/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.message.Message;
import com.linecorp.bot.model.message.quickreply.QuickReply;
import lombok.NonNull;

@JsonTypeName(value="sticker")
@JsonDeserialize(builder=StickerMessageBuilder.class)
public final class StickerMessage
implements Message {
    @NonNull
    private final String packageId;
    @NonNull
    private final String stickerId;
    private final QuickReply quickReply;

    public StickerMessage(String packageId, String stickerId) {
        this(packageId, stickerId, null);
    }

    public static StickerMessageBuilder builder() {
        return new StickerMessageBuilder();
    }

    public StickerMessageBuilder toBuilder() {
        return new StickerMessageBuilder().packageId(this.packageId).stickerId(this.stickerId).quickReply(this.quickReply);
    }

    @NonNull
    public String getPackageId() {
        return this.packageId;
    }

    @NonNull
    public String getStickerId() {
        return this.stickerId;
    }

    @Override
    public QuickReply getQuickReply() {
        return this.quickReply;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StickerMessage)) {
            return false;
        }
        StickerMessage other = (StickerMessage)o;
        String this$packageId = this.getPackageId();
        String other$packageId = other.getPackageId();
        if (this$packageId == null ? other$packageId != null : !this$packageId.equals(other$packageId)) {
            return false;
        }
        String this$stickerId = this.getStickerId();
        String other$stickerId = other.getStickerId();
        if (this$stickerId == null ? other$stickerId != null : !this$stickerId.equals(other$stickerId)) {
            return false;
        }
        QuickReply this$quickReply = this.getQuickReply();
        QuickReply other$quickReply = other.getQuickReply();
        return !(this$quickReply == null ? other$quickReply != null : !((Object)this$quickReply).equals(other$quickReply));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $packageId = this.getPackageId();
        result = result * 59 + ($packageId == null ? 43 : $packageId.hashCode());
        String $stickerId = this.getStickerId();
        result = result * 59 + ($stickerId == null ? 43 : $stickerId.hashCode());
        QuickReply $quickReply = this.getQuickReply();
        result = result * 59 + ($quickReply == null ? 43 : ((Object)$quickReply).hashCode());
        return result;
    }

    public String toString() {
        return "StickerMessage(packageId=" + this.getPackageId() + ", stickerId=" + this.getStickerId() + ", quickReply=" + this.getQuickReply() + ")";
    }

    private StickerMessage(@NonNull String packageId, @NonNull String stickerId, QuickReply quickReply) {
        if (packageId == null) {
            throw new NullPointerException("packageId is marked non-null but is null");
        }
        if (stickerId == null) {
            throw new NullPointerException("stickerId is marked non-null but is null");
        }
        this.packageId = packageId;
        this.stickerId = stickerId;
        this.quickReply = quickReply;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class StickerMessageBuilder {
        private String packageId;
        private String stickerId;
        private QuickReply quickReply;

        StickerMessageBuilder() {
        }

        public StickerMessageBuilder packageId(@NonNull String packageId) {
            if (packageId == null) {
                throw new NullPointerException("packageId is marked non-null but is null");
            }
            this.packageId = packageId;
            return this;
        }

        public StickerMessageBuilder stickerId(@NonNull String stickerId) {
            if (stickerId == null) {
                throw new NullPointerException("stickerId is marked non-null but is null");
            }
            this.stickerId = stickerId;
            return this;
        }

        public StickerMessageBuilder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        public StickerMessage build() {
            return new StickerMessage(this.packageId, this.stickerId, this.quickReply);
        }

        public String toString() {
            return "StickerMessage.StickerMessageBuilder(packageId=" + this.packageId + ", stickerId=" + this.stickerId + ", quickReply=" + this.quickReply + ")";
        }
    }
}

