/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.message.Message;
import com.linecorp.bot.model.message.quickreply.QuickReply;
import lombok.NonNull;

@JsonTypeName(value="text")
@JsonDeserialize(builder=TextMessageBuilder.class)
public final class TextMessage
implements Message {
    @NonNull
    private final String text;
    private final QuickReply quickReply;

    public TextMessage(String text) {
        this.text = text;
        this.quickReply = null;
    }

    public static TextMessageBuilder builder() {
        return new TextMessageBuilder();
    }

    public TextMessageBuilder toBuilder() {
        return new TextMessageBuilder().text(this.text).quickReply(this.quickReply);
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    @Override
    public QuickReply getQuickReply() {
        return this.quickReply;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextMessage)) {
            return false;
        }
        TextMessage other = (TextMessage)o;
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        QuickReply this$quickReply = this.getQuickReply();
        QuickReply other$quickReply = other.getQuickReply();
        return !(this$quickReply == null ? other$quickReply != null : !((Object)this$quickReply).equals(other$quickReply));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        QuickReply $quickReply = this.getQuickReply();
        result = result * 59 + ($quickReply == null ? 43 : ((Object)$quickReply).hashCode());
        return result;
    }

    public String toString() {
        return "TextMessage(text=" + this.getText() + ", quickReply=" + this.getQuickReply() + ")";
    }

    public TextMessage(@NonNull String text, QuickReply quickReply) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
        this.quickReply = quickReply;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class TextMessageBuilder {
        private String text;
        private QuickReply quickReply;

        TextMessageBuilder() {
        }

        public TextMessageBuilder text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this;
        }

        public TextMessageBuilder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        public TextMessage build() {
            return new TextMessage(this.text, this.quickReply);
        }

        public String toString() {
            return "TextMessage.TextMessageBuilder(text=" + this.text + ", quickReply=" + this.quickReply + ")";
        }
    }
}

