/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.message.Message;
import com.linecorp.bot.model.message.quickreply.QuickReply;
import java.net.URI;
import lombok.NonNull;

@JsonTypeName(value="video")
@JsonDeserialize(builder=VideoMessageBuilder.class)
public final class VideoMessage
implements Message {
    @NonNull
    private final URI originalContentUrl;
    @NonNull
    private final URI previewImageUrl;
    private final QuickReply quickReply;

    public VideoMessage(URI originalContentUrl, URI previewImageUrl) {
        this(originalContentUrl, previewImageUrl, null);
    }

    public static VideoMessageBuilder builder() {
        return new VideoMessageBuilder();
    }

    public VideoMessageBuilder toBuilder() {
        return new VideoMessageBuilder().originalContentUrl(this.originalContentUrl).previewImageUrl(this.previewImageUrl).quickReply(this.quickReply);
    }

    @NonNull
    public URI getOriginalContentUrl() {
        return this.originalContentUrl;
    }

    @NonNull
    public URI getPreviewImageUrl() {
        return this.previewImageUrl;
    }

    @Override
    public QuickReply getQuickReply() {
        return this.quickReply;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoMessage)) {
            return false;
        }
        VideoMessage other = (VideoMessage)o;
        URI this$originalContentUrl = this.getOriginalContentUrl();
        URI other$originalContentUrl = other.getOriginalContentUrl();
        if (this$originalContentUrl == null ? other$originalContentUrl != null : !((Object)this$originalContentUrl).equals(other$originalContentUrl)) {
            return false;
        }
        URI this$previewImageUrl = this.getPreviewImageUrl();
        URI other$previewImageUrl = other.getPreviewImageUrl();
        if (this$previewImageUrl == null ? other$previewImageUrl != null : !((Object)this$previewImageUrl).equals(other$previewImageUrl)) {
            return false;
        }
        QuickReply this$quickReply = this.getQuickReply();
        QuickReply other$quickReply = other.getQuickReply();
        return !(this$quickReply == null ? other$quickReply != null : !((Object)this$quickReply).equals(other$quickReply));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $originalContentUrl = this.getOriginalContentUrl();
        result = result * 59 + ($originalContentUrl == null ? 43 : ((Object)$originalContentUrl).hashCode());
        URI $previewImageUrl = this.getPreviewImageUrl();
        result = result * 59 + ($previewImageUrl == null ? 43 : ((Object)$previewImageUrl).hashCode());
        QuickReply $quickReply = this.getQuickReply();
        result = result * 59 + ($quickReply == null ? 43 : ((Object)$quickReply).hashCode());
        return result;
    }

    public String toString() {
        return "VideoMessage(originalContentUrl=" + this.getOriginalContentUrl() + ", previewImageUrl=" + this.getPreviewImageUrl() + ", quickReply=" + this.getQuickReply() + ")";
    }

    private VideoMessage(@NonNull URI originalContentUrl, @NonNull URI previewImageUrl, QuickReply quickReply) {
        if (originalContentUrl == null) {
            throw new NullPointerException("originalContentUrl is marked non-null but is null");
        }
        if (previewImageUrl == null) {
            throw new NullPointerException("previewImageUrl is marked non-null but is null");
        }
        this.originalContentUrl = originalContentUrl;
        this.previewImageUrl = previewImageUrl;
        this.quickReply = quickReply;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class VideoMessageBuilder {
        private URI originalContentUrl;
        private URI previewImageUrl;
        private QuickReply quickReply;

        VideoMessageBuilder() {
        }

        public VideoMessageBuilder originalContentUrl(@NonNull URI originalContentUrl) {
            if (originalContentUrl == null) {
                throw new NullPointerException("originalContentUrl is marked non-null but is null");
            }
            this.originalContentUrl = originalContentUrl;
            return this;
        }

        public VideoMessageBuilder previewImageUrl(@NonNull URI previewImageUrl) {
            if (previewImageUrl == null) {
                throw new NullPointerException("previewImageUrl is marked non-null but is null");
            }
            this.previewImageUrl = previewImageUrl;
            return this;
        }

        public VideoMessageBuilder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        public VideoMessage build() {
            return new VideoMessage(this.originalContentUrl, this.previewImageUrl, this.quickReply);
        }

        public String toString() {
            return "VideoMessage.VideoMessageBuilder(originalContentUrl=" + this.originalContentUrl + ", previewImageUrl=" + this.previewImageUrl + ", quickReply=" + this.quickReply + ")";
        }
    }
}

