/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message.flex.component;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.linecorp.bot.model.action.Action;
import com.linecorp.bot.model.message.flex.component.FlexComponent;
import com.linecorp.bot.model.message.flex.unit.FlexAlign;
import com.linecorp.bot.model.message.flex.unit.FlexGravity;
import com.linecorp.bot.model.message.flex.unit.FlexMarginSize;
import com.linecorp.bot.model.message.flex.unit.FlexOffsetSize;
import com.linecorp.bot.model.message.flex.unit.FlexPosition;
import java.net.URI;
import java.text.DecimalFormat;

@JsonTypeName(value="image")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Image
implements FlexComponent {
    private final Integer flex;
    private final URI url;
    private final ImageSize size;
    private final String aspectRatio;
    private final ImageAspectMode aspectMode;
    private final String backgroundColor;
    private final FlexAlign align;
    private final Action action;
    private final FlexGravity gravity;
    private final FlexMarginSize margin;
    private final FlexPosition position;
    private final String offsetTop;
    private final String offsetBottom;
    private final String offsetStart;
    private final String offsetEnd;

    @JsonCreator
    public Image(@JsonProperty(value="flex") Integer flex, @JsonProperty(value="url") URI url, @JsonProperty(value="size") ImageSize size, @JsonProperty(value="aspectRatio") String aspectRatio, @JsonProperty(value="aspectMode") ImageAspectMode aspectMode, @JsonProperty(value="backgroundColor") String backgroundColor, @JsonProperty(value="align") FlexAlign align, @JsonProperty(value="action") Action action, @JsonProperty(value="gravity") FlexGravity gravity, @JsonProperty(value="margin") FlexMarginSize margin, @JsonProperty(value="position") FlexPosition position, @JsonProperty(value="offsetTop") String offsetTop, @JsonProperty(value="offsetBottom") String offsetBottom, @JsonProperty(value="offsetStart") String offsetStart, @JsonProperty(value="offsetEnd") String offsetEnd) {
        this.flex = flex;
        this.url = url;
        this.size = size;
        this.aspectRatio = aspectRatio;
        this.aspectMode = aspectMode;
        this.backgroundColor = backgroundColor;
        this.align = align;
        this.action = action;
        this.gravity = gravity;
        this.margin = margin;
        this.position = position;
        this.offsetTop = offsetTop;
        this.offsetBottom = offsetBottom;
        this.offsetStart = offsetStart;
        this.offsetEnd = offsetEnd;
    }

    public static ImageBuilder builder() {
        return new ImageBuilder();
    }

    public Integer getFlex() {
        return this.flex;
    }

    public URI getUrl() {
        return this.url;
    }

    public ImageSize getSize() {
        return this.size;
    }

    public String getAspectRatio() {
        return this.aspectRatio;
    }

    public ImageAspectMode getAspectMode() {
        return this.aspectMode;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public FlexAlign getAlign() {
        return this.align;
    }

    public Action getAction() {
        return this.action;
    }

    public FlexGravity getGravity() {
        return this.gravity;
    }

    public FlexMarginSize getMargin() {
        return this.margin;
    }

    public FlexPosition getPosition() {
        return this.position;
    }

    public String getOffsetTop() {
        return this.offsetTop;
    }

    public String getOffsetBottom() {
        return this.offsetBottom;
    }

    public String getOffsetStart() {
        return this.offsetStart;
    }

    public String getOffsetEnd() {
        return this.offsetEnd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image other = (Image)o;
        Integer this$flex = this.getFlex();
        Integer other$flex = other.getFlex();
        if (this$flex == null ? other$flex != null : !((Object)this$flex).equals(other$flex)) {
            return false;
        }
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        ImageSize this$size = this.getSize();
        ImageSize other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)((Object)this$size)).equals((Object)other$size)) {
            return false;
        }
        String this$aspectRatio = this.getAspectRatio();
        String other$aspectRatio = other.getAspectRatio();
        if (this$aspectRatio == null ? other$aspectRatio != null : !this$aspectRatio.equals(other$aspectRatio)) {
            return false;
        }
        ImageAspectMode this$aspectMode = this.getAspectMode();
        ImageAspectMode other$aspectMode = other.getAspectMode();
        if (this$aspectMode == null ? other$aspectMode != null : !((Object)((Object)this$aspectMode)).equals((Object)other$aspectMode)) {
            return false;
        }
        String this$backgroundColor = this.getBackgroundColor();
        String other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !this$backgroundColor.equals(other$backgroundColor)) {
            return false;
        }
        FlexAlign this$align = this.getAlign();
        FlexAlign other$align = other.getAlign();
        if (this$align == null ? other$align != null : !((Object)((Object)this$align)).equals((Object)other$align)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        FlexGravity this$gravity = this.getGravity();
        FlexGravity other$gravity = other.getGravity();
        if (this$gravity == null ? other$gravity != null : !((Object)((Object)this$gravity)).equals((Object)other$gravity)) {
            return false;
        }
        FlexMarginSize this$margin = this.getMargin();
        FlexMarginSize other$margin = other.getMargin();
        if (this$margin == null ? other$margin != null : !((Object)((Object)this$margin)).equals((Object)other$margin)) {
            return false;
        }
        FlexPosition this$position = this.getPosition();
        FlexPosition other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)((Object)this$position)).equals((Object)other$position)) {
            return false;
        }
        String this$offsetTop = this.getOffsetTop();
        String other$offsetTop = other.getOffsetTop();
        if (this$offsetTop == null ? other$offsetTop != null : !this$offsetTop.equals(other$offsetTop)) {
            return false;
        }
        String this$offsetBottom = this.getOffsetBottom();
        String other$offsetBottom = other.getOffsetBottom();
        if (this$offsetBottom == null ? other$offsetBottom != null : !this$offsetBottom.equals(other$offsetBottom)) {
            return false;
        }
        String this$offsetStart = this.getOffsetStart();
        String other$offsetStart = other.getOffsetStart();
        if (this$offsetStart == null ? other$offsetStart != null : !this$offsetStart.equals(other$offsetStart)) {
            return false;
        }
        String this$offsetEnd = this.getOffsetEnd();
        String other$offsetEnd = other.getOffsetEnd();
        return !(this$offsetEnd == null ? other$offsetEnd != null : !this$offsetEnd.equals(other$offsetEnd));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $flex = this.getFlex();
        result = result * 59 + ($flex == null ? 43 : ((Object)$flex).hashCode());
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        ImageSize $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)((Object)$size)).hashCode());
        String $aspectRatio = this.getAspectRatio();
        result = result * 59 + ($aspectRatio == null ? 43 : $aspectRatio.hashCode());
        ImageAspectMode $aspectMode = this.getAspectMode();
        result = result * 59 + ($aspectMode == null ? 43 : ((Object)((Object)$aspectMode)).hashCode());
        String $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : $backgroundColor.hashCode());
        FlexAlign $align = this.getAlign();
        result = result * 59 + ($align == null ? 43 : ((Object)((Object)$align)).hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        FlexGravity $gravity = this.getGravity();
        result = result * 59 + ($gravity == null ? 43 : ((Object)((Object)$gravity)).hashCode());
        FlexMarginSize $margin = this.getMargin();
        result = result * 59 + ($margin == null ? 43 : ((Object)((Object)$margin)).hashCode());
        FlexPosition $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)((Object)$position)).hashCode());
        String $offsetTop = this.getOffsetTop();
        result = result * 59 + ($offsetTop == null ? 43 : $offsetTop.hashCode());
        String $offsetBottom = this.getOffsetBottom();
        result = result * 59 + ($offsetBottom == null ? 43 : $offsetBottom.hashCode());
        String $offsetStart = this.getOffsetStart();
        result = result * 59 + ($offsetStart == null ? 43 : $offsetStart.hashCode());
        String $offsetEnd = this.getOffsetEnd();
        result = result * 59 + ($offsetEnd == null ? 43 : $offsetEnd.hashCode());
        return result;
    }

    public String toString() {
        return "Image(flex=" + this.getFlex() + ", url=" + this.getUrl() + ", size=" + (Object)((Object)this.getSize()) + ", aspectRatio=" + this.getAspectRatio() + ", aspectMode=" + (Object)((Object)this.getAspectMode()) + ", backgroundColor=" + this.getBackgroundColor() + ", align=" + (Object)((Object)this.getAlign()) + ", action=" + this.getAction() + ", gravity=" + (Object)((Object)this.getGravity()) + ", margin=" + (Object)((Object)this.getMargin()) + ", position=" + (Object)((Object)this.getPosition()) + ", offsetTop=" + this.getOffsetTop() + ", offsetBottom=" + this.getOffsetBottom() + ", offsetStart=" + this.getOffsetStart() + ", offsetEnd=" + this.getOffsetEnd() + ")";
    }

    public static class ImageBuilder {
        private Integer flex;
        private URI url;
        private ImageSize size;
        private String aspectRatio;
        private ImageAspectMode aspectMode;
        private String backgroundColor;
        private FlexAlign align;
        private Action action;
        private FlexGravity gravity;
        private FlexMarginSize margin;
        private FlexPosition position;
        private String offsetTop;
        private String offsetBottom;
        private String offsetStart;
        private String offsetEnd;
        private static final DecimalFormat RATIO_FORMAT = new DecimalFormat("0.#####");

        public ImageBuilder aspectRatio(ImageAspectRatio aspectRatio) {
            this.aspectRatio = aspectRatio.getRatio();
            return this;
        }

        public ImageBuilder aspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public ImageBuilder aspectRatio(double width, double height) {
            this.aspectRatio = RATIO_FORMAT.format(width) + ":" + RATIO_FORMAT.format(height);
            return this;
        }

        public ImageBuilder offsetTop(FlexOffsetSize offset) {
            this.offsetTop = offset.getPropertyValue();
            return this;
        }

        public ImageBuilder offsetTop(String offset) {
            this.offsetTop = offset;
            return this;
        }

        public ImageBuilder offsetBottom(FlexOffsetSize offset) {
            this.offsetBottom = offset.getPropertyValue();
            return this;
        }

        public ImageBuilder offsetBottom(String offset) {
            this.offsetBottom = offset;
            return this;
        }

        public ImageBuilder offsetStart(FlexOffsetSize offset) {
            this.offsetStart = offset.getPropertyValue();
            return this;
        }

        public ImageBuilder offsetStart(String offset) {
            this.offsetStart = offset;
            return this;
        }

        public ImageBuilder offsetEnd(FlexOffsetSize offset) {
            this.offsetEnd = offset.getPropertyValue();
            return this;
        }

        public ImageBuilder offsetEnd(String offset) {
            this.offsetEnd = offset;
            return this;
        }

        ImageBuilder() {
        }

        public ImageBuilder flex(Integer flex) {
            this.flex = flex;
            return this;
        }

        public ImageBuilder url(URI url) {
            this.url = url;
            return this;
        }

        public ImageBuilder size(ImageSize size) {
            this.size = size;
            return this;
        }

        public ImageBuilder aspectMode(ImageAspectMode aspectMode) {
            this.aspectMode = aspectMode;
            return this;
        }

        public ImageBuilder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public ImageBuilder align(FlexAlign align) {
            this.align = align;
            return this;
        }

        public ImageBuilder action(Action action) {
            this.action = action;
            return this;
        }

        public ImageBuilder gravity(FlexGravity gravity) {
            this.gravity = gravity;
            return this;
        }

        public ImageBuilder margin(FlexMarginSize margin) {
            this.margin = margin;
            return this;
        }

        public ImageBuilder position(FlexPosition position) {
            this.position = position;
            return this;
        }

        public Image build() {
            return new Image(this.flex, this.url, this.size, this.aspectRatio, this.aspectMode, this.backgroundColor, this.align, this.action, this.gravity, this.margin, this.position, this.offsetTop, this.offsetBottom, this.offsetStart, this.offsetEnd);
        }

        public String toString() {
            return "Image.ImageBuilder(flex=" + this.flex + ", url=" + this.url + ", size=" + (Object)((Object)this.size) + ", aspectRatio=" + this.aspectRatio + ", aspectMode=" + (Object)((Object)this.aspectMode) + ", backgroundColor=" + this.backgroundColor + ", align=" + (Object)((Object)this.align) + ", action=" + this.action + ", gravity=" + (Object)((Object)this.gravity) + ", margin=" + (Object)((Object)this.margin) + ", position=" + (Object)((Object)this.position) + ", offsetTop=" + this.offsetTop + ", offsetBottom=" + this.offsetBottom + ", offsetStart=" + this.offsetStart + ", offsetEnd=" + this.offsetEnd + ")";
        }
    }

    public static enum ImageAspectMode {
        Fit,
        Cover;

    }

    public static enum ImageAspectRatio {
        R1TO1("1:1"),
        R20TO13("20:13"),
        R1_91TO1("1.91:1"),
        R4TO3("4:3"),
        R16TO9("16:9"),
        R2TO1("2:1"),
        R3TO1("3:1"),
        R3TO4("3:4"),
        R9TO16("9:16"),
        R1TO2("1:2"),
        R1TO3("1:3"),
        R1_51TO1("1.51:1");

        private final String ratio;

        private ImageAspectRatio(String ratio) {
            this.ratio = ratio;
        }

        public String getRatio() {
            return this.ratio;
        }
    }

    public static enum ImageSize {
        XXS,
        XS,
        SM,
        MD,
        LG,
        XL,
        XXL,
        XXXL,
        XXXXL,
        XXXXXL,
        FULL_WIDTH;

    }
}

