/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message.imagemap;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.message.imagemap.ImagemapArea;
import com.linecorp.bot.model.message.imagemap.ImagemapExternalLink;
import java.net.URI;

@JsonDeserialize(builder=ImagemapVideoBuilder.class)
public final class ImagemapVideo {
    private final URI originalContentUrl;
    private final URI previewImageUrl;
    private final ImagemapArea area;
    private final ImagemapExternalLink externalLink;

    public static ImagemapVideoBuilder builder() {
        return new ImagemapVideoBuilder();
    }

    public URI getOriginalContentUrl() {
        return this.originalContentUrl;
    }

    public URI getPreviewImageUrl() {
        return this.previewImageUrl;
    }

    public ImagemapArea getArea() {
        return this.area;
    }

    public ImagemapExternalLink getExternalLink() {
        return this.externalLink;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImagemapVideo)) {
            return false;
        }
        ImagemapVideo other = (ImagemapVideo)o;
        URI this$originalContentUrl = this.getOriginalContentUrl();
        URI other$originalContentUrl = other.getOriginalContentUrl();
        if (this$originalContentUrl == null ? other$originalContentUrl != null : !((Object)this$originalContentUrl).equals(other$originalContentUrl)) {
            return false;
        }
        URI this$previewImageUrl = this.getPreviewImageUrl();
        URI other$previewImageUrl = other.getPreviewImageUrl();
        if (this$previewImageUrl == null ? other$previewImageUrl != null : !((Object)this$previewImageUrl).equals(other$previewImageUrl)) {
            return false;
        }
        ImagemapArea this$area = this.getArea();
        ImagemapArea other$area = other.getArea();
        if (this$area == null ? other$area != null : !((Object)this$area).equals(other$area)) {
            return false;
        }
        ImagemapExternalLink this$externalLink = this.getExternalLink();
        ImagemapExternalLink other$externalLink = other.getExternalLink();
        return !(this$externalLink == null ? other$externalLink != null : !((Object)this$externalLink).equals(other$externalLink));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $originalContentUrl = this.getOriginalContentUrl();
        result = result * 59 + ($originalContentUrl == null ? 43 : ((Object)$originalContentUrl).hashCode());
        URI $previewImageUrl = this.getPreviewImageUrl();
        result = result * 59 + ($previewImageUrl == null ? 43 : ((Object)$previewImageUrl).hashCode());
        ImagemapArea $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : ((Object)$area).hashCode());
        ImagemapExternalLink $externalLink = this.getExternalLink();
        result = result * 59 + ($externalLink == null ? 43 : ((Object)$externalLink).hashCode());
        return result;
    }

    public String toString() {
        return "ImagemapVideo(originalContentUrl=" + this.getOriginalContentUrl() + ", previewImageUrl=" + this.getPreviewImageUrl() + ", area=" + this.getArea() + ", externalLink=" + this.getExternalLink() + ")";
    }

    public ImagemapVideo(URI originalContentUrl, URI previewImageUrl, ImagemapArea area, ImagemapExternalLink externalLink) {
        this.originalContentUrl = originalContentUrl;
        this.previewImageUrl = previewImageUrl;
        this.area = area;
        this.externalLink = externalLink;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class ImagemapVideoBuilder {
        private URI originalContentUrl;
        private URI previewImageUrl;
        private ImagemapArea area;
        private ImagemapExternalLink externalLink;

        ImagemapVideoBuilder() {
        }

        public ImagemapVideoBuilder originalContentUrl(URI originalContentUrl) {
            this.originalContentUrl = originalContentUrl;
            return this;
        }

        public ImagemapVideoBuilder previewImageUrl(URI previewImageUrl) {
            this.previewImageUrl = previewImageUrl;
            return this;
        }

        public ImagemapVideoBuilder area(ImagemapArea area) {
            this.area = area;
            return this;
        }

        public ImagemapVideoBuilder externalLink(ImagemapExternalLink externalLink) {
            this.externalLink = externalLink;
            return this;
        }

        public ImagemapVideo build() {
            return new ImagemapVideo(this.originalContentUrl, this.previewImageUrl, this.area, this.externalLink);
        }

        public String toString() {
            return "ImagemapVideo.ImagemapVideoBuilder(originalContentUrl=" + this.originalContentUrl + ", previewImageUrl=" + this.previewImageUrl + ", area=" + this.area + ", externalLink=" + this.externalLink + ")";
        }
    }
}

