/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.response.demographics;

import com.linecorp.bot.model.response.demographics.AgeRange;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class AgeRangeImpl
implements AgeRange {
    private static final String JSON_UNKNOWN_VALUE = "unknown";
    private static final Pattern VALUE_PATTERN = Pattern.compile("from(?<from>\\d+)(?:to(?<to>\\d+))?");
    private final OptionalInt from;
    private final OptionalInt to;

    static AgeRange valueOf(String value) {
        if (value.equals(JSON_UNKNOWN_VALUE)) {
            return AgeRange.UNKNOWN;
        }
        AgeRangeImplBuilder builder = AgeRangeImpl.builder();
        Matcher matcher = VALUE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unexpected format: " + value);
        }
        builder.from(OptionalInt.of(Integer.parseInt(matcher.group("from"))));
        if (matcher.group("to") != null) {
            builder.to(OptionalInt.of(Integer.parseInt(matcher.group("to"))));
        }
        return builder.build();
    }

    @Override
    public String getJsonRawValue() {
        if (AgeRange.UNKNOWN.equals(this)) {
            return JSON_UNKNOWN_VALUE;
        }
        StringBuilder sb = new StringBuilder();
        if (this.from.isPresent()) {
            sb.append("from" + this.from.getAsInt());
        }
        if (this.to.isPresent()) {
            sb.append("to" + this.to.getAsInt());
        }
        return sb.toString();
    }

    public String toString() {
        return this.getJsonRawValue();
    }

    private static OptionalInt $default$from() {
        return OptionalInt.empty();
    }

    private static OptionalInt $default$to() {
        return OptionalInt.empty();
    }

    AgeRangeImpl(OptionalInt from, OptionalInt to) {
        this.from = from;
        this.to = to;
    }

    public static AgeRangeImplBuilder builder() {
        return new AgeRangeImplBuilder();
    }

    @Override
    public OptionalInt getFrom() {
        return this.from;
    }

    @Override
    public OptionalInt getTo() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgeRangeImpl)) {
            return false;
        }
        AgeRangeImpl other = (AgeRangeImpl)o;
        OptionalInt this$from = this.getFrom();
        OptionalInt other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        OptionalInt this$to = this.getTo();
        OptionalInt other$to = other.getTo();
        return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OptionalInt $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        OptionalInt $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        return result;
    }

    public static class AgeRangeImplBuilder {
        private boolean from$set;
        private OptionalInt from;
        private boolean to$set;
        private OptionalInt to;

        AgeRangeImplBuilder() {
        }

        public AgeRangeImplBuilder from(OptionalInt from) {
            this.from = from;
            this.from$set = true;
            return this;
        }

        public AgeRangeImplBuilder to(OptionalInt to) {
            this.to = to;
            this.to$set = true;
            return this;
        }

        public AgeRangeImpl build() {
            OptionalInt from = this.from;
            if (!this.from$set) {
                from = AgeRangeImpl.$default$from();
            }
            OptionalInt to = this.to;
            if (!this.to$set) {
                to = AgeRangeImpl.$default$to();
            }
            return new AgeRangeImpl(from, to);
        }

        public String toString() {
            return "AgeRangeImpl.AgeRangeImplBuilder(from=" + this.from + ", to=" + this.to + ")";
        }
    }
}

