/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.response.demographics;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.response.demographics.AgeRange;

@JsonDeserialize(builder=AgeTileBuilder.class)
final class AgeTile {
    private final AgeRange age;
    private final double percentage;

    AgeTile(AgeRange age, double percentage) {
        this.age = age;
        this.percentage = percentage;
    }

    public static AgeTileBuilder builder() {
        return new AgeTileBuilder();
    }

    public AgeRange getAge() {
        return this.age;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgeTile)) {
            return false;
        }
        AgeTile other = (AgeTile)o;
        AgeRange this$age = this.getAge();
        AgeRange other$age = other.getAge();
        if (this$age == null ? other$age != null : !this$age.equals(other$age)) {
            return false;
        }
        return Double.compare(this.getPercentage(), other.getPercentage()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AgeRange $age = this.getAge();
        result = result * 59 + ($age == null ? 43 : $age.hashCode());
        long $percentage = Double.doubleToLongBits(this.getPercentage());
        result = result * 59 + (int)($percentage >>> 32 ^ $percentage);
        return result;
    }

    public String toString() {
        return "AgeTile(age=" + this.getAge() + ", percentage=" + this.getPercentage() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class AgeTileBuilder {
        private AgeRange age;
        private double percentage;

        AgeTileBuilder() {
        }

        public AgeTileBuilder age(AgeRange age) {
            this.age = age;
            return this;
        }

        public AgeTileBuilder percentage(double percentage) {
            this.percentage = percentage;
            return this;
        }

        public AgeTile build() {
            return new AgeTile(this.age, this.percentage);
        }

        public String toString() {
            return "AgeTile.AgeTileBuilder(age=" + this.age + ", percentage=" + this.percentage + ")";
        }
    }
}

