/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.response.demographics;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonDeserialize(builder=AppTypeTileBuilder.class)
final class AppTypeTile {
    private final AppType appType;
    private final double percentage;

    AppTypeTile(AppType appType, double percentage) {
        this.appType = appType;
        this.percentage = percentage;
    }

    public static AppTypeTileBuilder builder() {
        return new AppTypeTileBuilder();
    }

    public AppType getAppType() {
        return this.appType;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppTypeTile)) {
            return false;
        }
        AppTypeTile other = (AppTypeTile)o;
        AppType this$appType = this.getAppType();
        AppType other$appType = other.getAppType();
        if (this$appType == null ? other$appType != null : !((Object)((Object)this$appType)).equals((Object)other$appType)) {
            return false;
        }
        return Double.compare(this.getPercentage(), other.getPercentage()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AppType $appType = this.getAppType();
        result = result * 59 + ($appType == null ? 43 : ((Object)((Object)$appType)).hashCode());
        long $percentage = Double.doubleToLongBits(this.getPercentage());
        result = result * 59 + (int)($percentage >>> 32 ^ $percentage);
        return result;
    }

    public String toString() {
        return "AppTypeTile(appType=" + (Object)((Object)this.getAppType()) + ", percentage=" + this.getPercentage() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class AppTypeTileBuilder {
        private AppType appType;
        private double percentage;

        AppTypeTileBuilder() {
        }

        public AppTypeTileBuilder appType(AppType appType) {
            this.appType = appType;
            return this;
        }

        public AppTypeTileBuilder percentage(double percentage) {
            this.percentage = percentage;
            return this;
        }

        public AppTypeTile build() {
            return new AppTypeTile(this.appType, this.percentage);
        }

        public String toString() {
            return "AppTypeTile.AppTypeTileBuilder(appType=" + (Object)((Object)this.appType) + ", percentage=" + this.percentage + ")";
        }
    }

    public static enum AppType {
        IOS,
        ANDROID,
        OTHERS;

    }
}

