/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.response.demographics;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonDeserialize(builder=AreaTileBuilder.class)
final class AreaTile {
    private final String area;
    private final double percentage;

    AreaTile(String area, double percentage) {
        this.area = area;
        this.percentage = percentage;
    }

    public static AreaTileBuilder builder() {
        return new AreaTileBuilder();
    }

    public String getArea() {
        return this.area;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AreaTile)) {
            return false;
        }
        AreaTile other = (AreaTile)o;
        String this$area = this.getArea();
        String other$area = other.getArea();
        if (this$area == null ? other$area != null : !this$area.equals(other$area)) {
            return false;
        }
        return Double.compare(this.getPercentage(), other.getPercentage()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : $area.hashCode());
        long $percentage = Double.doubleToLongBits(this.getPercentage());
        result = result * 59 + (int)($percentage >>> 32 ^ $percentage);
        return result;
    }

    public String toString() {
        return "AreaTile(area=" + this.getArea() + ", percentage=" + this.getPercentage() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class AreaTileBuilder {
        private String area;
        private double percentage;

        AreaTileBuilder() {
        }

        public AreaTileBuilder area(String area) {
            this.area = area;
            return this;
        }

        public AreaTileBuilder percentage(double percentage) {
            this.percentage = percentage;
            return this;
        }

        public AreaTile build() {
            return new AreaTile(this.area, this.percentage);
        }

        public String toString() {
            return "AreaTile.AreaTileBuilder(area=" + this.area + ", percentage=" + this.percentage + ")";
        }
    }
}

