/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.response.demographics;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonDeserialize(builder=GenderTileBuilder.class)
final class GenderTile {
    private final Gender gender;
    private final double percentage;

    GenderTile(Gender gender, double percentage) {
        this.gender = gender;
        this.percentage = percentage;
    }

    public static GenderTileBuilder builder() {
        return new GenderTileBuilder();
    }

    public Gender getGender() {
        return this.gender;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenderTile)) {
            return false;
        }
        GenderTile other = (GenderTile)o;
        Gender this$gender = this.getGender();
        Gender other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !((Object)((Object)this$gender)).equals((Object)other$gender)) {
            return false;
        }
        return Double.compare(this.getPercentage(), other.getPercentage()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Gender $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : ((Object)((Object)$gender)).hashCode());
        long $percentage = Double.doubleToLongBits(this.getPercentage());
        result = result * 59 + (int)($percentage >>> 32 ^ $percentage);
        return result;
    }

    public String toString() {
        return "GenderTile(gender=" + (Object)((Object)this.getGender()) + ", percentage=" + this.getPercentage() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class GenderTileBuilder {
        private Gender gender;
        private double percentage;

        GenderTileBuilder() {
        }

        public GenderTileBuilder gender(Gender gender) {
            this.gender = gender;
            return this;
        }

        public GenderTileBuilder percentage(double percentage) {
            this.percentage = percentage;
            return this;
        }

        public GenderTile build() {
            return new GenderTile(this.gender, this.percentage);
        }

        public String toString() {
            return "GenderTile.GenderTileBuilder(gender=" + (Object)((Object)this.gender) + ", percentage=" + this.percentage + ")";
        }
    }

    static enum Gender {
        MALE,
        FEMALE,
        UNKNOWN;

    }
}

