/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.response.demographics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface SubscriptionPeriod {
    @JsonCreator
    public static SubscriptionPeriod valueOf(String value) {
        WellKnownValue wellknownValue = (WellKnownValue)WellKnownValue.RAW_VALUE_MAP.get(value);
        if (wellknownValue != null) {
            return wellknownValue;
        }
        return new UnknownValue(value);
    }

    public OptionalInt getWithin();

    @JsonValue
    public String getJsonRawValue();

    public static final class UnknownValue
    implements SubscriptionPeriod {
        private static final Pattern WITHIN_NUM_PATTERN = Pattern.compile("within(\\d+)days");
        private final OptionalInt within;
        private final String jsonRawValue;

        UnknownValue(String jsonRawValue) {
            Matcher matcher = WITHIN_NUM_PATTERN.matcher(jsonRawValue);
            this.within = matcher.matches() ? OptionalInt.of(Integer.parseInt(matcher.group(1))) : OptionalInt.empty();
            this.jsonRawValue = jsonRawValue;
        }

        public String toString() {
            return this.jsonRawValue;
        }

        @Override
        public OptionalInt getWithin() {
            return this.within;
        }

        @Override
        public String getJsonRawValue() {
            return this.jsonRawValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnknownValue)) {
                return false;
            }
            UnknownValue other = (UnknownValue)o;
            OptionalInt this$within = this.getWithin();
            OptionalInt other$within = other.getWithin();
            if (this$within == null ? other$within != null : !((Object)this$within).equals(other$within)) {
                return false;
            }
            String this$jsonRawValue = this.getJsonRawValue();
            String other$jsonRawValue = other.getJsonRawValue();
            return !(this$jsonRawValue == null ? other$jsonRawValue != null : !this$jsonRawValue.equals(other$jsonRawValue));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            OptionalInt $within = this.getWithin();
            result = result * 59 + ($within == null ? 43 : ((Object)$within).hashCode());
            String $jsonRawValue = this.getJsonRawValue();
            result = result * 59 + ($jsonRawValue == null ? 43 : $jsonRawValue.hashCode());
            return result;
        }
    }

    public static enum WellKnownValue implements SubscriptionPeriod
    {
        WITHIN7DAYS(7, "within7days"),
        WITHIN30DAYS(30, "within30days"),
        WITHIN90DAYS(90, "within90days"),
        WITHIN180DAYS(180, "within180days"),
        WITHIN365DAYS(365, "within365days"),
        OVER365DAYS(null, "over365days"),
        UNKNOWN(null, "unknown");

        private static final Map<String, WellKnownValue> RAW_VALUE_MAP;
        private final OptionalInt within;
        private final String jsonRawValue;

        private WellKnownValue(Integer within, String jsonRawValue) {
            this.within = within == null ? OptionalInt.empty() : OptionalInt.of(within);
            this.jsonRawValue = jsonRawValue;
        }

        public String toString() {
            return this.jsonRawValue;
        }

        @Override
        public OptionalInt getWithin() {
            return this.within;
        }

        @Override
        public String getJsonRawValue() {
            return this.jsonRawValue;
        }

        static {
            RAW_VALUE_MAP = Arrays.stream(WellKnownValue.values()).collect(Collectors.toMap(WellKnownValue::getJsonRawValue, Function.identity()));
        }
    }
}

