/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.richmenu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class RichMenuBulkLinkRequest {
    private final String richMenuId;
    private final List<String> userIds;

    RichMenuBulkLinkRequest(String richMenuId, List<String> userIds) {
        this.richMenuId = richMenuId;
        this.userIds = userIds;
    }

    public static RichMenuBulkLinkRequestBuilder builder() {
        return new RichMenuBulkLinkRequestBuilder();
    }

    public String getRichMenuId() {
        return this.richMenuId;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RichMenuBulkLinkRequest)) {
            return false;
        }
        RichMenuBulkLinkRequest other = (RichMenuBulkLinkRequest)o;
        String this$richMenuId = this.getRichMenuId();
        String other$richMenuId = other.getRichMenuId();
        if (this$richMenuId == null ? other$richMenuId != null : !this$richMenuId.equals(other$richMenuId)) {
            return false;
        }
        List<String> this$userIds = this.getUserIds();
        List<String> other$userIds = other.getUserIds();
        return !(this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $richMenuId = this.getRichMenuId();
        result = result * 59 + ($richMenuId == null ? 43 : $richMenuId.hashCode());
        List<String> $userIds = this.getUserIds();
        result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
        return result;
    }

    public String toString() {
        return "RichMenuBulkLinkRequest(richMenuId=" + this.getRichMenuId() + ", userIds=" + this.getUserIds() + ")";
    }

    public static class RichMenuBulkLinkRequestBuilder {
        private String richMenuId;
        private ArrayList<String> userIds;

        RichMenuBulkLinkRequestBuilder() {
        }

        public RichMenuBulkLinkRequestBuilder richMenuId(String richMenuId) {
            this.richMenuId = richMenuId;
            return this;
        }

        public RichMenuBulkLinkRequestBuilder userId(String userId) {
            if (this.userIds == null) {
                this.userIds = new ArrayList();
            }
            this.userIds.add(userId);
            return this;
        }

        public RichMenuBulkLinkRequestBuilder userIds(Collection<? extends String> userIds) {
            if (this.userIds == null) {
                this.userIds = new ArrayList();
            }
            this.userIds.addAll(userIds);
            return this;
        }

        public RichMenuBulkLinkRequestBuilder clearUserIds() {
            if (this.userIds != null) {
                this.userIds.clear();
            }
            return this;
        }

        public RichMenuBulkLinkRequest build() {
            List<String> userIds;
            switch (this.userIds == null ? 0 : this.userIds.size()) {
                case 0: {
                    userIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    userIds = Collections.singletonList(this.userIds.get(0));
                    break;
                }
                default: {
                    userIds = Collections.unmodifiableList(new ArrayList<String>(this.userIds));
                }
            }
            return new RichMenuBulkLinkRequest(this.richMenuId, userIds);
        }

        public String toString() {
            return "RichMenuBulkLinkRequest.RichMenuBulkLinkRequestBuilder(richMenuId=" + this.richMenuId + ", userIds=" + this.userIds + ")";
        }
    }
}

