/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.richmenu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class RichMenuBulkUnlinkRequest {
    private final List<String> userIds;

    RichMenuBulkUnlinkRequest(List<String> userIds) {
        this.userIds = userIds;
    }

    public static RichMenuBulkUnlinkRequestBuilder builder() {
        return new RichMenuBulkUnlinkRequestBuilder();
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RichMenuBulkUnlinkRequest)) {
            return false;
        }
        RichMenuBulkUnlinkRequest other = (RichMenuBulkUnlinkRequest)o;
        List<String> this$userIds = this.getUserIds();
        List<String> other$userIds = other.getUserIds();
        return !(this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $userIds = this.getUserIds();
        result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
        return result;
    }

    public String toString() {
        return "RichMenuBulkUnlinkRequest(userIds=" + this.getUserIds() + ")";
    }

    public static class RichMenuBulkUnlinkRequestBuilder {
        private ArrayList<String> userIds;

        RichMenuBulkUnlinkRequestBuilder() {
        }

        public RichMenuBulkUnlinkRequestBuilder userId(String userId) {
            if (this.userIds == null) {
                this.userIds = new ArrayList();
            }
            this.userIds.add(userId);
            return this;
        }

        public RichMenuBulkUnlinkRequestBuilder userIds(Collection<? extends String> userIds) {
            if (this.userIds == null) {
                this.userIds = new ArrayList();
            }
            this.userIds.addAll(userIds);
            return this;
        }

        public RichMenuBulkUnlinkRequestBuilder clearUserIds() {
            if (this.userIds != null) {
                this.userIds.clear();
            }
            return this;
        }

        public RichMenuBulkUnlinkRequest build() {
            List<String> userIds;
            switch (this.userIds == null ? 0 : this.userIds.size()) {
                case 0: {
                    userIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    userIds = Collections.singletonList(this.userIds.get(0));
                    break;
                }
                default: {
                    userIds = Collections.unmodifiableList(new ArrayList<String>(this.userIds));
                }
            }
            return new RichMenuBulkUnlinkRequest(userIds);
        }

        public String toString() {
            return "RichMenuBulkUnlinkRequest.RichMenuBulkUnlinkRequestBuilder(userIds=" + this.userIds + ")";
        }
    }
}

