/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.event.beacon;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.bot.model.event.beacon.BeaconContentUtil;
import java.util.Arrays;
import lombok.Generated;

public final class BeaconContent {
    private final String hwid;
    private final String type;
    private final byte[] deviceMessage;

    public byte[] getDeviceMessage() {
        if (this.deviceMessage == null) {
            return null;
        }
        return (byte[])this.deviceMessage.clone();
    }

    public String getDeviceMessageAsHex() {
        return BeaconContentUtil.printHexBinary(this.deviceMessage);
    }

    @JsonCreator
    public BeaconContent(@JsonProperty(value="hwid") String hwid, @JsonProperty(value="type") String type, @JsonProperty(value="dm") String deviceMessage) {
        this.hwid = hwid;
        this.type = type;
        this.deviceMessage = BeaconContentUtil.parseBytesOrNull(deviceMessage);
    }

    public String toString() {
        return "BeaconContent(hwid=" + this.getHwid() + ", type=" + this.getType() + ", deviceMessage=" + this.getDeviceMessageAsHex() + ')';
    }

    @Generated
    public String getHwid() {
        return this.hwid;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeaconContent)) {
            return false;
        }
        BeaconContent other = (BeaconContent)o;
        String this$hwid = this.getHwid();
        String other$hwid = other.getHwid();
        if (this$hwid == null ? other$hwid != null : !this$hwid.equals(other$hwid)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        return Arrays.equals(this.getDeviceMessage(), other.getDeviceMessage());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hwid = this.getHwid();
        result = result * 59 + ($hwid == null ? 43 : $hwid.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + Arrays.hashCode(this.getDeviceMessage());
        return result;
    }
}

