/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message.flex.component;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.message.flex.component.FlexComponent;
import com.linecorp.bot.model.message.flex.unit.FlexFontSize;
import com.linecorp.bot.model.message.flex.unit.FlexMarginSize;
import com.linecorp.bot.model.message.flex.unit.FlexOffsetSize;
import com.linecorp.bot.model.message.flex.unit.FlexPosition;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.function.Supplier;
import lombok.Generated;

@JsonTypeName(value="icon")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=IconBuilder.class)
public final class Icon
implements FlexComponent {
    private final URI url;
    private final String size;
    private final String aspectRatio;
    private final String margin;
    private final FlexPosition position;
    private final String offsetTop;
    private final String offsetBottom;
    private final String offsetStart;
    private final String offsetEnd;

    @Generated
    Icon(URI url, String size, String aspectRatio, String margin, FlexPosition position, String offsetTop, String offsetBottom, String offsetStart, String offsetEnd) {
        this.url = url;
        this.size = size;
        this.aspectRatio = aspectRatio;
        this.margin = margin;
        this.position = position;
        this.offsetTop = offsetTop;
        this.offsetBottom = offsetBottom;
        this.offsetStart = offsetStart;
        this.offsetEnd = offsetEnd;
    }

    @Generated
    public static IconBuilder builder() {
        return new IconBuilder();
    }

    @Generated
    public IconBuilder toBuilder() {
        return new IconBuilder().url(this.url).size(this.size).aspectRatio(this.aspectRatio).margin(this.margin).position(this.position).offsetTop(this.offsetTop).offsetBottom(this.offsetBottom).offsetStart(this.offsetStart).offsetEnd(this.offsetEnd);
    }

    @Generated
    public URI getUrl() {
        return this.url;
    }

    @Generated
    public String getSize() {
        return this.size;
    }

    @Generated
    public String getAspectRatio() {
        return this.aspectRatio;
    }

    @Generated
    public String getMargin() {
        return this.margin;
    }

    @Generated
    public FlexPosition getPosition() {
        return this.position;
    }

    @Generated
    public String getOffsetTop() {
        return this.offsetTop;
    }

    @Generated
    public String getOffsetBottom() {
        return this.offsetBottom;
    }

    @Generated
    public String getOffsetStart() {
        return this.offsetStart;
    }

    @Generated
    public String getOffsetEnd() {
        return this.offsetEnd;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Icon)) {
            return false;
        }
        Icon other = (Icon)o;
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$aspectRatio = this.getAspectRatio();
        String other$aspectRatio = other.getAspectRatio();
        if (this$aspectRatio == null ? other$aspectRatio != null : !this$aspectRatio.equals(other$aspectRatio)) {
            return false;
        }
        String this$margin = this.getMargin();
        String other$margin = other.getMargin();
        if (this$margin == null ? other$margin != null : !this$margin.equals(other$margin)) {
            return false;
        }
        FlexPosition this$position = this.getPosition();
        FlexPosition other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)((Object)this$position)).equals((Object)other$position)) {
            return false;
        }
        String this$offsetTop = this.getOffsetTop();
        String other$offsetTop = other.getOffsetTop();
        if (this$offsetTop == null ? other$offsetTop != null : !this$offsetTop.equals(other$offsetTop)) {
            return false;
        }
        String this$offsetBottom = this.getOffsetBottom();
        String other$offsetBottom = other.getOffsetBottom();
        if (this$offsetBottom == null ? other$offsetBottom != null : !this$offsetBottom.equals(other$offsetBottom)) {
            return false;
        }
        String this$offsetStart = this.getOffsetStart();
        String other$offsetStart = other.getOffsetStart();
        if (this$offsetStart == null ? other$offsetStart != null : !this$offsetStart.equals(other$offsetStart)) {
            return false;
        }
        String this$offsetEnd = this.getOffsetEnd();
        String other$offsetEnd = other.getOffsetEnd();
        return !(this$offsetEnd == null ? other$offsetEnd != null : !this$offsetEnd.equals(other$offsetEnd));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $aspectRatio = this.getAspectRatio();
        result = result * 59 + ($aspectRatio == null ? 43 : $aspectRatio.hashCode());
        String $margin = this.getMargin();
        result = result * 59 + ($margin == null ? 43 : $margin.hashCode());
        FlexPosition $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)((Object)$position)).hashCode());
        String $offsetTop = this.getOffsetTop();
        result = result * 59 + ($offsetTop == null ? 43 : $offsetTop.hashCode());
        String $offsetBottom = this.getOffsetBottom();
        result = result * 59 + ($offsetBottom == null ? 43 : $offsetBottom.hashCode());
        String $offsetStart = this.getOffsetStart();
        result = result * 59 + ($offsetStart == null ? 43 : $offsetStart.hashCode());
        String $offsetEnd = this.getOffsetEnd();
        result = result * 59 + ($offsetEnd == null ? 43 : $offsetEnd.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Icon(url=" + this.getUrl() + ", size=" + this.getSize() + ", aspectRatio=" + this.getAspectRatio() + ", margin=" + this.getMargin() + ", position=" + this.getPosition() + ", offsetTop=" + this.getOffsetTop() + ", offsetBottom=" + this.getOffsetBottom() + ", offsetStart=" + this.getOffsetStart() + ", offsetEnd=" + this.getOffsetEnd() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class IconBuilder {
        @Generated
        private URI url;
        @Generated
        private String size;
        @Generated
        private String aspectRatio;
        @Generated
        private String margin;
        @Generated
        private FlexPosition position;
        @Generated
        private String offsetTop;
        @Generated
        private String offsetBottom;
        @Generated
        private String offsetStart;
        @Generated
        private String offsetEnd;
        private static final Supplier<DecimalFormat> RATIO_FORMAT = () -> new DecimalFormat("0.#####");

        public IconBuilder size(FlexFontSize size) {
            this.size = size.getPropertyValue();
            return this;
        }

        public IconBuilder size(String size) {
            this.size = size;
            return this;
        }

        public IconBuilder margin(FlexMarginSize margin) {
            this.margin = margin.getPropertyValue();
            return this;
        }

        public IconBuilder margin(String margin) {
            this.margin = margin;
            return this;
        }

        public IconBuilder offsetTop(FlexOffsetSize offset) {
            this.offsetTop = offset.getPropertyValue();
            return this;
        }

        public IconBuilder offsetTop(String offset) {
            this.offsetTop = offset;
            return this;
        }

        public IconBuilder offsetBottom(FlexOffsetSize offset) {
            this.offsetBottom = offset.getPropertyValue();
            return this;
        }

        public IconBuilder offsetBottom(String offset) {
            this.offsetBottom = offset;
            return this;
        }

        public IconBuilder offsetStart(FlexOffsetSize offset) {
            this.offsetStart = offset.getPropertyValue();
            return this;
        }

        public IconBuilder offsetStart(String offset) {
            this.offsetStart = offset;
            return this;
        }

        public IconBuilder offsetEnd(FlexOffsetSize offset) {
            this.offsetEnd = offset.getPropertyValue();
            return this;
        }

        public IconBuilder offsetEnd(String offset) {
            this.offsetEnd = offset;
            return this;
        }

        public IconBuilder aspectRatio(IconAspectRatio aspectRatio) {
            this.aspectRatio = aspectRatio.getRatio();
            return this;
        }

        public IconBuilder aspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public IconBuilder aspectRatio(double width, double height) {
            DecimalFormat fmt = RATIO_FORMAT.get();
            this.aspectRatio = fmt.format(width) + ":" + fmt.format(height);
            return this;
        }

        @Generated
        IconBuilder() {
        }

        @Generated
        public IconBuilder url(URI url) {
            this.url = url;
            return this;
        }

        @Generated
        public IconBuilder position(FlexPosition position) {
            this.position = position;
            return this;
        }

        @Generated
        public Icon build() {
            return new Icon(this.url, this.size, this.aspectRatio, this.margin, this.position, this.offsetTop, this.offsetBottom, this.offsetStart, this.offsetEnd);
        }

        @Generated
        public String toString() {
            return "Icon.IconBuilder(url=" + this.url + ", size=" + this.size + ", aspectRatio=" + this.aspectRatio + ", margin=" + this.margin + ", position=" + this.position + ", offsetTop=" + this.offsetTop + ", offsetBottom=" + this.offsetBottom + ", offsetStart=" + this.offsetStart + ", offsetEnd=" + this.offsetEnd + ")";
        }
    }

    public static enum IconAspectRatio {
        R1TO1("1:1"),
        R2TO1("2:1"),
        R3TO1("3:1");

        private final String ratio;

        @Generated
        private IconAspectRatio(String ratio) {
            this.ratio = ratio;
        }

        @Generated
        public String getRatio() {
            return this.ratio;
        }
    }
}

