/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message.flex.component;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.action.Action;
import com.linecorp.bot.model.message.flex.component.FlexComponent;
import com.linecorp.bot.model.message.flex.unit.FlexAlign;
import com.linecorp.bot.model.message.flex.unit.FlexGravity;
import com.linecorp.bot.model.message.flex.unit.FlexMarginSize;
import com.linecorp.bot.model.message.flex.unit.FlexOffsetSize;
import com.linecorp.bot.model.message.flex.unit.FlexPosition;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.function.Supplier;
import lombok.Generated;

@JsonTypeName(value="image")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=ImageBuilder.class)
public final class Image
implements FlexComponent {
    private final Integer flex;
    private final URI url;
    private final String size;
    private final String aspectRatio;
    private final ImageAspectMode aspectMode;
    private final String backgroundColor;
    private final FlexAlign align;
    private final Action action;
    private final FlexGravity gravity;
    private final String margin;
    private final FlexPosition position;
    private final String offsetTop;
    private final String offsetBottom;
    private final String offsetStart;
    private final String offsetEnd;
    private final Boolean animated;

    @Generated
    Image(Integer flex, URI url, String size, String aspectRatio, ImageAspectMode aspectMode, String backgroundColor, FlexAlign align, Action action, FlexGravity gravity, String margin, FlexPosition position, String offsetTop, String offsetBottom, String offsetStart, String offsetEnd, Boolean animated) {
        this.flex = flex;
        this.url = url;
        this.size = size;
        this.aspectRatio = aspectRatio;
        this.aspectMode = aspectMode;
        this.backgroundColor = backgroundColor;
        this.align = align;
        this.action = action;
        this.gravity = gravity;
        this.margin = margin;
        this.position = position;
        this.offsetTop = offsetTop;
        this.offsetBottom = offsetBottom;
        this.offsetStart = offsetStart;
        this.offsetEnd = offsetEnd;
        this.animated = animated;
    }

    @Generated
    public static ImageBuilder builder() {
        return new ImageBuilder();
    }

    @Generated
    public ImageBuilder toBuilder() {
        return new ImageBuilder().flex(this.flex).url(this.url).size(this.size).aspectRatio(this.aspectRatio).aspectMode(this.aspectMode).backgroundColor(this.backgroundColor).align(this.align).action(this.action).gravity(this.gravity).margin(this.margin).position(this.position).offsetTop(this.offsetTop).offsetBottom(this.offsetBottom).offsetStart(this.offsetStart).offsetEnd(this.offsetEnd).animated(this.animated);
    }

    @Generated
    public Integer getFlex() {
        return this.flex;
    }

    @Generated
    public URI getUrl() {
        return this.url;
    }

    @Generated
    public String getSize() {
        return this.size;
    }

    @Generated
    public String getAspectRatio() {
        return this.aspectRatio;
    }

    @Generated
    public ImageAspectMode getAspectMode() {
        return this.aspectMode;
    }

    @Generated
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public FlexAlign getAlign() {
        return this.align;
    }

    @Generated
    public Action getAction() {
        return this.action;
    }

    @Generated
    public FlexGravity getGravity() {
        return this.gravity;
    }

    @Generated
    public String getMargin() {
        return this.margin;
    }

    @Generated
    public FlexPosition getPosition() {
        return this.position;
    }

    @Generated
    public String getOffsetTop() {
        return this.offsetTop;
    }

    @Generated
    public String getOffsetBottom() {
        return this.offsetBottom;
    }

    @Generated
    public String getOffsetStart() {
        return this.offsetStart;
    }

    @Generated
    public String getOffsetEnd() {
        return this.offsetEnd;
    }

    @Generated
    public Boolean getAnimated() {
        return this.animated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image other = (Image)o;
        Integer this$flex = this.getFlex();
        Integer other$flex = other.getFlex();
        if (this$flex == null ? other$flex != null : !((Object)this$flex).equals(other$flex)) {
            return false;
        }
        Boolean this$animated = this.getAnimated();
        Boolean other$animated = other.getAnimated();
        if (this$animated == null ? other$animated != null : !((Object)this$animated).equals(other$animated)) {
            return false;
        }
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$aspectRatio = this.getAspectRatio();
        String other$aspectRatio = other.getAspectRatio();
        if (this$aspectRatio == null ? other$aspectRatio != null : !this$aspectRatio.equals(other$aspectRatio)) {
            return false;
        }
        ImageAspectMode this$aspectMode = this.getAspectMode();
        ImageAspectMode other$aspectMode = other.getAspectMode();
        if (this$aspectMode == null ? other$aspectMode != null : !((Object)((Object)this$aspectMode)).equals((Object)other$aspectMode)) {
            return false;
        }
        String this$backgroundColor = this.getBackgroundColor();
        String other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !this$backgroundColor.equals(other$backgroundColor)) {
            return false;
        }
        FlexAlign this$align = this.getAlign();
        FlexAlign other$align = other.getAlign();
        if (this$align == null ? other$align != null : !((Object)((Object)this$align)).equals((Object)other$align)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        FlexGravity this$gravity = this.getGravity();
        FlexGravity other$gravity = other.getGravity();
        if (this$gravity == null ? other$gravity != null : !((Object)((Object)this$gravity)).equals((Object)other$gravity)) {
            return false;
        }
        String this$margin = this.getMargin();
        String other$margin = other.getMargin();
        if (this$margin == null ? other$margin != null : !this$margin.equals(other$margin)) {
            return false;
        }
        FlexPosition this$position = this.getPosition();
        FlexPosition other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)((Object)this$position)).equals((Object)other$position)) {
            return false;
        }
        String this$offsetTop = this.getOffsetTop();
        String other$offsetTop = other.getOffsetTop();
        if (this$offsetTop == null ? other$offsetTop != null : !this$offsetTop.equals(other$offsetTop)) {
            return false;
        }
        String this$offsetBottom = this.getOffsetBottom();
        String other$offsetBottom = other.getOffsetBottom();
        if (this$offsetBottom == null ? other$offsetBottom != null : !this$offsetBottom.equals(other$offsetBottom)) {
            return false;
        }
        String this$offsetStart = this.getOffsetStart();
        String other$offsetStart = other.getOffsetStart();
        if (this$offsetStart == null ? other$offsetStart != null : !this$offsetStart.equals(other$offsetStart)) {
            return false;
        }
        String this$offsetEnd = this.getOffsetEnd();
        String other$offsetEnd = other.getOffsetEnd();
        return !(this$offsetEnd == null ? other$offsetEnd != null : !this$offsetEnd.equals(other$offsetEnd));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $flex = this.getFlex();
        result = result * 59 + ($flex == null ? 43 : ((Object)$flex).hashCode());
        Boolean $animated = this.getAnimated();
        result = result * 59 + ($animated == null ? 43 : ((Object)$animated).hashCode());
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $aspectRatio = this.getAspectRatio();
        result = result * 59 + ($aspectRatio == null ? 43 : $aspectRatio.hashCode());
        ImageAspectMode $aspectMode = this.getAspectMode();
        result = result * 59 + ($aspectMode == null ? 43 : ((Object)((Object)$aspectMode)).hashCode());
        String $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : $backgroundColor.hashCode());
        FlexAlign $align = this.getAlign();
        result = result * 59 + ($align == null ? 43 : ((Object)((Object)$align)).hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        FlexGravity $gravity = this.getGravity();
        result = result * 59 + ($gravity == null ? 43 : ((Object)((Object)$gravity)).hashCode());
        String $margin = this.getMargin();
        result = result * 59 + ($margin == null ? 43 : $margin.hashCode());
        FlexPosition $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)((Object)$position)).hashCode());
        String $offsetTop = this.getOffsetTop();
        result = result * 59 + ($offsetTop == null ? 43 : $offsetTop.hashCode());
        String $offsetBottom = this.getOffsetBottom();
        result = result * 59 + ($offsetBottom == null ? 43 : $offsetBottom.hashCode());
        String $offsetStart = this.getOffsetStart();
        result = result * 59 + ($offsetStart == null ? 43 : $offsetStart.hashCode());
        String $offsetEnd = this.getOffsetEnd();
        result = result * 59 + ($offsetEnd == null ? 43 : $offsetEnd.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Image(flex=" + this.getFlex() + ", url=" + this.getUrl() + ", size=" + this.getSize() + ", aspectRatio=" + this.getAspectRatio() + ", aspectMode=" + this.getAspectMode() + ", backgroundColor=" + this.getBackgroundColor() + ", align=" + this.getAlign() + ", action=" + this.getAction() + ", gravity=" + this.getGravity() + ", margin=" + this.getMargin() + ", position=" + this.getPosition() + ", offsetTop=" + this.getOffsetTop() + ", offsetBottom=" + this.getOffsetBottom() + ", offsetStart=" + this.getOffsetStart() + ", offsetEnd=" + this.getOffsetEnd() + ", animated=" + this.getAnimated() + ")";
    }

    public static enum ImageAspectMode {
        Fit,
        Cover;

    }

    @JsonPOJOBuilder(withPrefix="")
    public static class ImageBuilder {
        @Generated
        private Integer flex;
        @Generated
        private URI url;
        @Generated
        private String size;
        @Generated
        private String aspectRatio;
        @Generated
        private ImageAspectMode aspectMode;
        @Generated
        private String backgroundColor;
        @Generated
        private FlexAlign align;
        @Generated
        private Action action;
        @Generated
        private FlexGravity gravity;
        @Generated
        private String margin;
        @Generated
        private FlexPosition position;
        @Generated
        private String offsetTop;
        @Generated
        private String offsetBottom;
        @Generated
        private String offsetStart;
        @Generated
        private String offsetEnd;
        @Generated
        private Boolean animated;
        private static final Supplier<DecimalFormat> RATIO_FORMAT = () -> new DecimalFormat("0.#####");

        public ImageBuilder size(ImageSize size) {
            this.size = size.getPropertyValue();
            return this;
        }

        public ImageBuilder size(String size) {
            this.size = size;
            return this;
        }

        public ImageBuilder aspectRatio(ImageAspectRatio aspectRatio) {
            this.aspectRatio = aspectRatio.getRatio();
            return this;
        }

        public ImageBuilder aspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public ImageBuilder aspectRatio(double width, double height) {
            DecimalFormat fmt = RATIO_FORMAT.get();
            this.aspectRatio = fmt.format(width) + ":" + fmt.format(height);
            return this;
        }

        public ImageBuilder margin(FlexMarginSize margin) {
            this.margin = margin.getPropertyValue();
            return this;
        }

        public ImageBuilder margin(String margin) {
            this.margin = margin;
            return this;
        }

        public ImageBuilder offsetTop(FlexOffsetSize offset) {
            this.offsetTop = offset.getPropertyValue();
            return this;
        }

        public ImageBuilder offsetTop(String offset) {
            this.offsetTop = offset;
            return this;
        }

        public ImageBuilder offsetBottom(FlexOffsetSize offset) {
            this.offsetBottom = offset.getPropertyValue();
            return this;
        }

        public ImageBuilder offsetBottom(String offset) {
            this.offsetBottom = offset;
            return this;
        }

        public ImageBuilder offsetStart(FlexOffsetSize offset) {
            this.offsetStart = offset.getPropertyValue();
            return this;
        }

        public ImageBuilder offsetStart(String offset) {
            this.offsetStart = offset;
            return this;
        }

        public ImageBuilder offsetEnd(FlexOffsetSize offset) {
            this.offsetEnd = offset.getPropertyValue();
            return this;
        }

        public ImageBuilder offsetEnd(String offset) {
            this.offsetEnd = offset;
            return this;
        }

        @Generated
        ImageBuilder() {
        }

        @Generated
        public ImageBuilder flex(Integer flex) {
            this.flex = flex;
            return this;
        }

        @Generated
        public ImageBuilder url(URI url) {
            this.url = url;
            return this;
        }

        @Generated
        public ImageBuilder aspectMode(ImageAspectMode aspectMode) {
            this.aspectMode = aspectMode;
            return this;
        }

        @Generated
        public ImageBuilder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Generated
        public ImageBuilder align(FlexAlign align) {
            this.align = align;
            return this;
        }

        @Generated
        public ImageBuilder action(Action action) {
            this.action = action;
            return this;
        }

        @Generated
        public ImageBuilder gravity(FlexGravity gravity) {
            this.gravity = gravity;
            return this;
        }

        @Generated
        public ImageBuilder position(FlexPosition position) {
            this.position = position;
            return this;
        }

        @Generated
        public ImageBuilder animated(Boolean animated) {
            this.animated = animated;
            return this;
        }

        @Generated
        public Image build() {
            return new Image(this.flex, this.url, this.size, this.aspectRatio, this.aspectMode, this.backgroundColor, this.align, this.action, this.gravity, this.margin, this.position, this.offsetTop, this.offsetBottom, this.offsetStart, this.offsetEnd, this.animated);
        }

        @Generated
        public String toString() {
            return "Image.ImageBuilder(flex=" + this.flex + ", url=" + this.url + ", size=" + this.size + ", aspectRatio=" + this.aspectRatio + ", aspectMode=" + this.aspectMode + ", backgroundColor=" + this.backgroundColor + ", align=" + this.align + ", action=" + this.action + ", gravity=" + this.gravity + ", margin=" + this.margin + ", position=" + this.position + ", offsetTop=" + this.offsetTop + ", offsetBottom=" + this.offsetBottom + ", offsetStart=" + this.offsetStart + ", offsetEnd=" + this.offsetEnd + ", animated=" + this.animated + ")";
        }
    }

    public static enum ImageAspectRatio {
        R1TO1("1:1"),
        R20TO13("20:13"),
        R1_91TO1("1.91:1"),
        R4TO3("4:3"),
        R16TO9("16:9"),
        R2TO1("2:1"),
        R3TO1("3:1"),
        R3TO4("3:4"),
        R9TO16("9:16"),
        R1TO2("1:2"),
        R1TO3("1:3"),
        R1_51TO1("1.51:1");

        private final String ratio;

        @Generated
        private ImageAspectRatio(String ratio) {
            this.ratio = ratio;
        }

        @Generated
        public String getRatio() {
            return this.ratio;
        }
    }

    public static enum ImageSize {
        XXS("xxs"),
        XS("xs"),
        SM("sm"),
        MD("md"),
        LG("lg"),
        XL("xl"),
        XXL("xxl"),
        XXXL("3xl"),
        XXXXL("4xl"),
        XXXXXL("5xl"),
        FULL_WIDTH("full");

        private final String propertyValue;

        @Generated
        private ImageSize(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        @Generated
        public String getPropertyValue() {
            return this.propertyValue;
        }
    }
}

