/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message.flex.component;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.action.Action;
import com.linecorp.bot.model.message.flex.component.FlexComponent;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;

@JsonTypeName(value="video")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=VideoBuilder.class)
public final class Video
implements FlexComponent {
    @NonNull
    private final URI url;
    @NonNull
    private final URI previewUrl;
    @NonNull
    private final FlexComponent altContent;
    @Nullable
    private final String aspectRatio;
    @Nullable
    private final Action action;

    @Generated
    Video(@NonNull URI url, @NonNull URI previewUrl, @NonNull FlexComponent altContent, String aspectRatio, Action action) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (previewUrl == null) {
            throw new NullPointerException("previewUrl is marked non-null but is null");
        }
        if (altContent == null) {
            throw new NullPointerException("altContent is marked non-null but is null");
        }
        this.url = url;
        this.previewUrl = previewUrl;
        this.altContent = altContent;
        this.aspectRatio = aspectRatio;
        this.action = action;
    }

    @Generated
    public static VideoBuilder builder() {
        return new VideoBuilder();
    }

    @Generated
    public VideoBuilder toBuilder() {
        return new VideoBuilder().url(this.url).previewUrl(this.previewUrl).altContent(this.altContent).aspectRatio(this.aspectRatio).action(this.action);
    }

    @NonNull
    @Generated
    public URI getUrl() {
        return this.url;
    }

    @NonNull
    @Generated
    public URI getPreviewUrl() {
        return this.previewUrl;
    }

    @NonNull
    @Generated
    public FlexComponent getAltContent() {
        return this.altContent;
    }

    @Generated
    public String getAspectRatio() {
        return this.aspectRatio;
    }

    @Generated
    public Action getAction() {
        return this.action;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Video)) {
            return false;
        }
        Video other = (Video)o;
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        URI this$previewUrl = this.getPreviewUrl();
        URI other$previewUrl = other.getPreviewUrl();
        if (this$previewUrl == null ? other$previewUrl != null : !((Object)this$previewUrl).equals(other$previewUrl)) {
            return false;
        }
        FlexComponent this$altContent = this.getAltContent();
        FlexComponent other$altContent = other.getAltContent();
        if (this$altContent == null ? other$altContent != null : !this$altContent.equals(other$altContent)) {
            return false;
        }
        String this$aspectRatio = this.getAspectRatio();
        String other$aspectRatio = other.getAspectRatio();
        if (this$aspectRatio == null ? other$aspectRatio != null : !this$aspectRatio.equals(other$aspectRatio)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        return !(this$action == null ? other$action != null : !this$action.equals(other$action));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        URI $previewUrl = this.getPreviewUrl();
        result = result * 59 + ($previewUrl == null ? 43 : ((Object)$previewUrl).hashCode());
        FlexComponent $altContent = this.getAltContent();
        result = result * 59 + ($altContent == null ? 43 : $altContent.hashCode());
        String $aspectRatio = this.getAspectRatio();
        result = result * 59 + ($aspectRatio == null ? 43 : $aspectRatio.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Video(url=" + this.getUrl() + ", previewUrl=" + this.getPreviewUrl() + ", altContent=" + this.getAltContent() + ", aspectRatio=" + this.getAspectRatio() + ", action=" + this.getAction() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class VideoBuilder {
        @Generated
        private URI url;
        @Generated
        private URI previewUrl;
        @Generated
        private FlexComponent altContent;
        @Generated
        private String aspectRatio;
        @Generated
        private Action action;
        private static final Supplier<DecimalFormat> RATIO_FORMAT = () -> new DecimalFormat("0.#####");

        public VideoBuilder aspectRatio(VideoAspectRatio aspectRatio) {
            this.aspectRatio = aspectRatio.getRatio();
            return this;
        }

        public VideoBuilder aspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public VideoBuilder aspectRatio(double width, double height) {
            DecimalFormat fmt = RATIO_FORMAT.get();
            this.aspectRatio = fmt.format(width) + ":" + fmt.format(height);
            return this;
        }

        @Generated
        VideoBuilder() {
        }

        @Generated
        public VideoBuilder url(@NonNull URI url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        @Generated
        public VideoBuilder previewUrl(@NonNull URI previewUrl) {
            if (previewUrl == null) {
                throw new NullPointerException("previewUrl is marked non-null but is null");
            }
            this.previewUrl = previewUrl;
            return this;
        }

        @Generated
        public VideoBuilder altContent(@NonNull FlexComponent altContent) {
            if (altContent == null) {
                throw new NullPointerException("altContent is marked non-null but is null");
            }
            this.altContent = altContent;
            return this;
        }

        @Generated
        public VideoBuilder action(Action action) {
            this.action = action;
            return this;
        }

        @Generated
        public Video build() {
            return new Video(this.url, this.previewUrl, this.altContent, this.aspectRatio, this.action);
        }

        @Generated
        public String toString() {
            return "Video.VideoBuilder(url=" + this.url + ", previewUrl=" + this.previewUrl + ", altContent=" + this.altContent + ", aspectRatio=" + this.aspectRatio + ", action=" + this.action + ")";
        }
    }

    public static enum VideoAspectRatio {
        R1TO1("1:1"),
        R20TO13("20:13"),
        R1_91TO1("1.91:1"),
        R4TO3("4:3"),
        R16TO9("16:9"),
        R2TO1("2:1"),
        R3TO1("3:1"),
        R3TO4("3:4"),
        R9TO16("9:16"),
        R1TO2("1:2"),
        R1TO3("1:3"),
        R1_51TO1("1.51:1");

        private final String ratio;

        @Generated
        private VideoAspectRatio(String ratio) {
            this.ratio = ratio;
        }

        @Generated
        public String getRatio() {
            return this.ratio;
        }
    }
}

