/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.objectmapper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StringArrayOrNullDeserializer
extends StdDeserializer<List<String>> {
    private static final long serialVersionUID = 1L;

    public StringArrayOrNullDeserializer() {
        super((Class)null);
    }

    public List<String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode rootNode = (JsonNode)p.getCodec().readTree(p);
        if (!rootNode.isArray()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (JsonNode element : rootNode) {
            if (!element.isTextual()) {
                return null;
            }
            result.add(element.textValue());
        }
        return result;
    }
}

