/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.module.client;

import com.linecorp.bot.client.base.ApiAuthenticatedClientBuilder;
import com.linecorp.bot.client.base.ExceptionBuilder;
import com.linecorp.bot.client.base.Result;
import com.linecorp.bot.client.base.channel.ChannelTokenSupplier;
import com.linecorp.bot.module.client.LineModuleExceptionBuilder;
import com.linecorp.bot.module.model.AcquireChatControlRequest;
import com.linecorp.bot.module.model.DetachModuleRequest;
import com.linecorp.bot.module.model.GetModulesResponse;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface LineModuleClient {
    @POST(value="/v2/bot/chat/{chatId}/control/acquire")
    public CompletableFuture<Result<Void>> acquireChatControl(@Path(value="chatId") String var1, @Body AcquireChatControlRequest var2);

    @POST(value="/v2/bot/channel/detach")
    public CompletableFuture<Result<Void>> detachModule(@Body DetachModuleRequest var1);

    @GET(value="/v2/bot/list")
    public CompletableFuture<Result<GetModulesResponse>> getModules(@Query(value="start") String var1, @Query(value="limit") Integer var2);

    @POST(value="/v2/bot/chat/{chatId}/control/release")
    public CompletableFuture<Result<Void>> releaseChatControl(@Path(value="chatId") String var1);

    public static ApiAuthenticatedClientBuilder<LineModuleClient> builder(String channelToken) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api.line.me"), LineModuleClient.class, (ExceptionBuilder)new LineModuleExceptionBuilder(), channelToken);
    }

    public static ApiAuthenticatedClientBuilder<LineModuleClient> builder(ChannelTokenSupplier channelTokenSupplier) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api.line.me"), LineModuleClient.class, (ExceptionBuilder)new LineModuleExceptionBuilder(), channelTokenSupplier);
    }
}

