/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.bot.model.event.CallbackRequest;
import com.linecorp.bot.model.objectmapper.ModelObjectMapper;
import com.linecorp.bot.parser.SignatureValidator;
import com.linecorp.bot.parser.WebhookParseException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookParser {
    private static final Logger log = LoggerFactory.getLogger(WebhookParser.class);
    private final ObjectMapper objectMapper = ModelObjectMapper.createNewObjectMapper();
    private final SignatureValidator signatureValidator;

    public WebhookParser(@NonNull SignatureValidator signatureValidator) {
        if (signatureValidator == null) {
            throw new NullPointerException("signatureValidator is marked non-null but is null");
        }
        this.signatureValidator = signatureValidator;
    }

    public CallbackRequest handle(String signature, byte[] payload) throws IOException, WebhookParseException {
        if (signature == null || signature.isEmpty()) {
            throw new WebhookParseException("Missing 'X-Line-Signature' header");
        }
        if (log.isDebugEnabled()) {
            log.debug("got: {}", (Object)new String(payload, StandardCharsets.UTF_8));
        }
        if (!this.signatureValidator.validateSignature(payload, signature)) {
            throw new WebhookParseException("Invalid API signature");
        }
        CallbackRequest callbackRequest = (CallbackRequest)this.objectMapper.readValue(payload, CallbackRequest.class);
        if (callbackRequest == null || callbackRequest.getEvents() == null) {
            throw new WebhookParseException("Invalid content");
        }
        return callbackRequest;
    }
}

