/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.parser;

import com.linecorp.bot.parser.SignatureValidator;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

public class LineSignatureValidator
implements SignatureValidator {
    private static final String HASH_ALGORITHM = "HmacSHA256";
    private final SecretKeySpec secretKeySpec;

    public LineSignatureValidator(byte[] channelSecret) {
        this.secretKeySpec = new SecretKeySpec(channelSecret, HASH_ALGORITHM);
    }

    @Override
    public boolean validateSignature(@NonNull byte[] content, @NonNull String headerSignature) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (headerSignature == null) {
            throw new NullPointerException("headerSignature is marked non-null but is null");
        }
        byte[] signature = this.generateSignature(content);
        byte[] decodeHeaderSignature = Base64.getDecoder().decode(headerSignature);
        return MessageDigest.isEqual(decodeHeaderSignature, signature);
    }

    public byte[] generateSignature(@NonNull byte[] content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        try {
            Mac mac = Mac.getInstance(HASH_ALGORITHM);
            mac.init(this.secretKeySpec);
            return mac.doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

