/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.parser;

import com.linecorp.bot.parser.SignatureValidator;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class LineSignatureValidator
implements SignatureValidator {
    private static final String HASH_ALGORITHM = "HmacSHA256";
    private final SecretKeySpec secretKeySpec;

    public LineSignatureValidator(byte[] channelSecret) {
        this.secretKeySpec = new SecretKeySpec(channelSecret, HASH_ALGORITHM);
    }

    @Override
    public boolean validateSignature(byte[] content, String headerSignature) {
        byte[] signature = this.generateSignature(Objects.requireNonNull(content, "content"));
        byte[] decodeHeaderSignature = Base64.getDecoder().decode(Objects.requireNonNull(headerSignature, "headerSignature"));
        return MessageDigest.isEqual(decodeHeaderSignature, signature);
    }

    public byte[] generateSignature(byte[] content) {
        try {
            Mac mac = Mac.getInstance(HASH_ALGORITHM);
            mac.init(this.secretKeySpec);
            return mac.doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

