/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.bot.jackson.ModelObjectMapper;
import com.linecorp.bot.parser.SignatureValidator;
import com.linecorp.bot.parser.WebhookParseException;
import com.linecorp.bot.webhook.model.CallbackRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookParser {
    public static final String SIGNATURE_HEADER_NAME = "X-Line-Signature";
    private static final Logger log = LoggerFactory.getLogger(WebhookParser.class);
    private final ObjectMapper objectMapper = ModelObjectMapper.createNewObjectMapper();
    private final SignatureValidator signatureValidator;

    public WebhookParser(SignatureValidator signatureValidator) {
        this.signatureValidator = Objects.requireNonNull(signatureValidator);
    }

    public CallbackRequest handle(String signature, byte[] payload) throws IOException, WebhookParseException {
        if (signature == null || signature.isEmpty()) {
            throw new WebhookParseException("Missing 'X-Line-Signature' header");
        }
        if (log.isDebugEnabled()) {
            log.debug("got: {}", (Object)new String(payload, StandardCharsets.UTF_8));
        }
        if (!this.signatureValidator.validateSignature(payload, signature)) {
            throw new WebhookParseException("Invalid API signature");
        }
        CallbackRequest callbackRequest = (CallbackRequest)this.objectMapper.readValue(payload, CallbackRequest.class);
        if (callbackRequest == null || callbackRequest.events() == null) {
            throw new WebhookParseException("Invalid content");
        }
        return callbackRequest;
    }
}

