/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.servlet;

import com.google.common.io.ByteStreams;
import com.linecorp.bot.model.event.CallbackRequest;
import com.linecorp.bot.parser.LineSignatureValidator;
import com.linecorp.bot.parser.SignatureValidator;
import com.linecorp.bot.parser.WebhookParseException;
import com.linecorp.bot.parser.WebhookParser;
import com.linecorp.bot.servlet.LineBotCallbackException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineBotCallbackRequestParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LineBotCallbackRequestParser.class);
    private final WebhookParser parser;

    public LineBotCallbackRequestParser(@NonNull LineSignatureValidator lineSignatureValidator) {
        if (lineSignatureValidator == null) {
            throw new NullPointerException("lineSignatureValidator is marked non-null but is null");
        }
        this.parser = new WebhookParser((SignatureValidator)lineSignatureValidator);
    }

    public CallbackRequest handle(HttpServletRequest req) throws LineBotCallbackException, IOException {
        String signature = req.getHeader("X-Line-Signature");
        byte[] json = ByteStreams.toByteArray((InputStream)req.getInputStream());
        try {
            return this.parser.handle(signature, json);
        }
        catch (WebhookParseException e) {
            throw new LineBotCallbackException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

