/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot.handler.support;

import com.linecorp.bot.spring.boot.handler.annotation.EventMapping;
import com.linecorp.bot.spring.boot.handler.argument.ArgumentResolver;
import com.linecorp.bot.spring.boot.handler.argument.EventArgumentResolver;
import com.linecorp.bot.spring.boot.handler.argument.LineBotDestinationArgumentResolver;
import com.linecorp.bot.spring.boot.handler.argument.MessageContentArgumentResolver;
import com.linecorp.bot.spring.boot.web.argument.annotation.LineBotDestination;
import com.linecorp.bot.webhook.model.Event;
import com.linecorp.bot.webhook.model.MessageContent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

record HandlerMethod(List<ArgumentResolver> argumentResolvers, Object object, Method handler, int priority) {
    public static HandlerMethod of(Object object, Method handler, EventMapping mapping) {
        ArrayList<ArgumentResolver> argumentResolvers = new ArrayList<ArgumentResolver>();
        int parameterCount = handler.getParameterCount();
        Type[] types = handler.getGenericParameterTypes();
        Annotation[][] parameterAnnotationsArray = handler.getParameterAnnotations();
        for (int i = 0; i < parameterCount; ++i) {
            Type type = types[i];
            Annotation[] parameterAnnotations = parameterAnnotationsArray[i];
            argumentResolvers.add(HandlerMethod.createArgumentResolver(type, parameterAnnotations));
        }
        return new HandlerMethod(argumentResolvers, object, handler, HandlerMethod.calcPriority(mapping, types));
    }

    private static ArgumentResolver createArgumentResolver(Type type, Annotation[] parameterAnnotations) {
        if (Arrays.stream(parameterAnnotations).filter(it -> it instanceof LineBotDestination).count() == 1L) {
            return new LineBotDestinationArgumentResolver();
        }
        if (type instanceof Class) {
            if (Event.class.isAssignableFrom((Class)type)) {
                return new EventArgumentResolver(type);
            }
            if (MessageContent.class.isAssignableFrom((Class)type)) {
                return new MessageContentArgumentResolver(type);
            }
            throw new IllegalArgumentException("Unsupported type set for @EventMapping: " + type);
        }
        throw new IllegalArgumentException("Unsupported type set for @EventMapping: " + type);
    }

    private static int calcPriority(EventMapping mapping, Type[] types) {
        if (mapping.priority() != -1) {
            return mapping.priority();
        }
        return Arrays.stream(types).mapToInt(type -> {
            if (type == String.class) {
                return 1;
            }
            if (type == Event.class) {
                return 0;
            }
            if (type instanceof Class) {
                return ((Class)type).isInterface() ? 10 : 100;
            }
            if (type instanceof ParameterizedType) {
                return 1000;
            }
            throw new IllegalStateException();
        }).sum();
    }

    Object invoke(String destination, Event event) throws Exception {
        Object[] args = this.argumentResolvers().stream().map(argumentResolver -> argumentResolver.resolve(destination, event)).toArray();
        return this.handler.invoke(this.object, args);
    }

    public boolean isSupported(Event event) {
        return this.argumentResolvers.stream().allMatch(argumentResolver -> argumentResolver.isSupported(event));
    }
}

