/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot.handler.support;

import com.linecorp.bot.spring.boot.handler.annotation.EventMapping;
import com.linecorp.bot.spring.boot.handler.support.HandlerMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ReflectionUtils;

public class HandlerMethodScanner {
    private static final Comparator<HandlerMethod> HANDLER_METHOD_PRIORITY_COMPARATOR = Comparator.comparing(HandlerMethod::priority).reversed();

    public List<HandlerMethod> scan(Collection<Object> objects) {
        return objects.stream().flatMap(this::scanObjectWithoutSorting).sorted(HANDLER_METHOD_PRIORITY_COMPARATOR).collect(Collectors.toList());
    }

    Stream<HandlerMethod> scanObjectWithoutSorting(Object object) {
        Method[] uniqueDeclaredMethods = ReflectionUtils.getUniqueDeclaredMethods(object.getClass());
        return Arrays.stream(uniqueDeclaredMethods).map(method -> this.getMethodHandlerMethodFunction(object, (Method)method)).filter(Objects::nonNull);
    }

    private HandlerMethod getMethodHandlerMethodFunction(Object consumer, Method method) {
        EventMapping mapping = (EventMapping)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, EventMapping.class);
        if (mapping == null) {
            return null;
        }
        return HandlerMethod.of(consumer, method, mapping);
    }
}

