/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot.handler.support;

import com.linecorp.bot.spring.boot.handler.annotation.LineMessageHandler;
import com.linecorp.bot.spring.boot.handler.properties.HandlerProperties;
import com.linecorp.bot.spring.boot.handler.support.HandlerMethod;
import com.linecorp.bot.spring.boot.handler.support.HandlerMethodScanner;
import com.linecorp.bot.spring.boot.handler.support.ReplyByReturnValueConsumer;
import com.linecorp.bot.spring.boot.web.argument.annotation.LineBotDestination;
import com.linecorp.bot.spring.boot.web.argument.annotation.LineBotMessages;
import com.linecorp.bot.webhook.model.Event;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Import(value={ReplyByReturnValueConsumer.Factory.class})
@ConditionalOnProperty(name={"line.bot.handler.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={HandlerProperties.class})
public class LineMessageHandlerSupport {
    private static final Logger log = LoggerFactory.getLogger(LineMessageHandlerSupport.class);
    private final ReplyByReturnValueConsumer.Factory returnValueConsumerFactory;
    private final ConfigurableApplicationContext applicationContext;
    private final HandlerMethodScanner handlerMethodScanner = new HandlerMethodScanner();
    volatile List<HandlerMethod> handlerMethods;

    public LineMessageHandlerSupport(ReplyByReturnValueConsumer.Factory returnValueConsumerFactory, ConfigurableApplicationContext applicationContext) {
        this.returnValueConsumerFactory = returnValueConsumerFactory;
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void initialize() {
        this.applicationContext.addApplicationListener(event -> {
            if (event instanceof ContextRefreshedEvent) {
                this.refresh();
            }
        });
    }

    void refresh() {
        Collection<Object> handlerBeans = this.applicationContext.getBeansWithAnnotation(LineMessageHandler.class).values();
        List<HandlerMethod> handlerMethods = this.handlerMethodScanner.scan(handlerBeans);
        log.info("Registered LINE Messaging API event handler: count = {}", (Object)handlerMethods.size());
        handlerMethods.forEach(item -> log.info("Mapped \"{}\" onto {}", item.argumentResolvers(), (Object)item.handler().toGenericString()));
        this.handlerMethods = handlerMethods;
    }

    @PostMapping(value={"${line.bot.handler.path:/callback}"})
    public void callback(@LineBotDestination String destination, @LineBotMessages List<Event> events) {
        events.forEach(event -> this.dispatch(destination, (Event)event));
    }

    void dispatch(String destination, Event event) {
        try {
            this.dispatchInternal(destination, event);
        }
        catch (InvocationTargetException e) {
            log.error("InvocationTargetException occurred.", (Throwable)e);
        }
        catch (Error | Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private void dispatchInternal(String destination, Event event) throws Exception {
        HandlerMethod handlerMethod = this.handlerMethods.stream().filter(handler -> handler.isSupported(event)).findFirst().orElseThrow(() -> new UnsupportedOperationException("Unsupported event type. " + event));
        Object returnValue = handlerMethod.invoke(destination, event);
        this.handleReturnValue(event, returnValue);
    }

    private void handleReturnValue(Event event, Object returnValue) {
        if (returnValue != null) {
            this.returnValueConsumerFactory.createForEvent(event).accept(returnValue);
        }
    }
}

