/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot.handler.support;

import com.linecorp.bot.client.base.Result;
import com.linecorp.bot.messaging.client.MessagingApiClient;
import com.linecorp.bot.messaging.model.Message;
import com.linecorp.bot.messaging.model.ReplyMessageRequest;
import com.linecorp.bot.messaging.model.ReplyMessageResponse;
import com.linecorp.bot.webhook.model.Event;
import com.linecorp.bot.webhook.model.ReplyEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

class ReplyByReturnValueConsumer
implements Consumer<Object> {
    private static final Logger log = LoggerFactory.getLogger(ReplyByReturnValueConsumer.class);
    private final MessagingApiClient messagingApiClient;
    private final Event originalEvent;

    ReplyByReturnValueConsumer(MessagingApiClient messagingApiClient, Event originalEvent) {
        this.messagingApiClient = messagingApiClient;
        this.originalEvent = originalEvent;
    }

    @Override
    public void accept(Object returnValue) {
        if (returnValue instanceof CompletableFuture) {
            ((CompletableFuture)returnValue).whenComplete(this::whenComplete);
        } else {
            this.acceptResult(returnValue);
        }
    }

    private void whenComplete(Object futureResult, Throwable throwable) {
        if (throwable != null) {
            log.error("Method return value waited but exception occurred in CompletedFuture", throwable);
            return;
        }
        this.acceptResult(futureResult);
    }

    private void acceptResult(Object returnValue) {
        if (returnValue instanceof Message) {
            this.reply(Collections.singletonList((Message)returnValue));
        } else if (returnValue instanceof List) {
            List returnValueAsList = (List)returnValue;
            if (returnValueAsList.isEmpty()) {
                return;
            }
            this.reply(ReplyByReturnValueConsumer.checkListContents(returnValueAsList));
        }
    }

    private void reply(List<Message> messages) {
        ReplyEvent replyEvent = (ReplyEvent)this.originalEvent;
        this.messagingApiClient.replyMessage(new ReplyMessageRequest(replyEvent.replyToken(), messages, Boolean.valueOf(false))).whenComplete(this::logging);
    }

    private void logging(Result<ReplyMessageResponse> unused, Throwable throwable) {
        if (throwable == null) {
            log.debug("Reply message success");
        } else {
            log.warn("Reply message failed: " + throwable.getMessage(), throwable);
        }
    }

    static List<Message> checkListContents(List<?> list) {
        for (int i = 0; i < list.size(); ++i) {
            Message item = list.get(i);
            Objects.requireNonNull(item, "item is null: " + list);
            if (item instanceof Message) continue;
            throw new IllegalArgumentException("List contains not Message type object. type = " + item.getClass());
        }
        return list;
    }

    @Component
    static class Factory {
        private final MessagingApiClient messagingApiClient;

        @Autowired
        Factory(MessagingApiClient messagingApiClient) {
            this.messagingApiClient = messagingApiClient;
        }

        ReplyByReturnValueConsumer createForEvent(Event event) {
            return new ReplyByReturnValueConsumer(this.messagingApiClient, event);
        }
    }
}

