/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot.web.configuration;

import com.linecorp.bot.parser.LineSignatureValidator;
import com.linecorp.bot.parser.SignatureValidator;
import com.linecorp.bot.parser.WebhookParser;
import com.linecorp.bot.spring.boot.core.properties.LineBotProperties;
import com.linecorp.bot.spring.boot.web.argument.support.LineBotDestinationArgumentProcessor;
import com.linecorp.bot.spring.boot.web.argument.support.LineBotServerArgumentProcessor;
import com.linecorp.bot.spring.boot.web.interceptor.LineBotServerInterceptor;
import java.nio.charset.StandardCharsets;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnWebApplication
@Import(value={LineBotServerInterceptor.class, LineBotServerArgumentProcessor.class, LineBotDestinationArgumentProcessor.class})
public class LineBotWebBeans {
    private final LineBotProperties lineBotProperties;

    public LineBotWebBeans(LineBotProperties lineBotProperties) {
        this.lineBotProperties = lineBotProperties;
    }

    @Bean
    public LineSignatureValidator lineSignatureValidator() {
        return new LineSignatureValidator(this.lineBotProperties.channelSecret().getBytes(StandardCharsets.US_ASCII));
    }

    @Bean
    public WebhookParser lineBotCallbackRequestParser(LineSignatureValidator lineSignatureValidator) {
        return new WebhookParser((SignatureValidator)lineSignatureValidator);
    }
}

