/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot.web.interceptor;

import com.linecorp.bot.parser.WebhookParseException;
import com.linecorp.bot.parser.WebhookParser;
import com.linecorp.bot.spring.boot.web.argument.annotation.LineBotMessages;
import com.linecorp.bot.spring.boot.web.argument.support.LineBotDestinationArgumentProcessor;
import com.linecorp.bot.spring.boot.web.argument.support.LineBotServerArgumentProcessor;
import com.linecorp.bot.webhook.model.CallbackRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class LineBotServerInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LineBotServerInterceptor.class);
    private final WebhookParser webhookParser;

    public LineBotServerInterceptor(WebhookParser webhookParser) {
        this.webhookParser = webhookParser;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        MethodParameter[] methodParameters;
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod hm = (HandlerMethod)handler;
        for (MethodParameter methodParameter : methodParameters = hm.getMethodParameters()) {
            if (methodParameter.getParameterAnnotation(LineBotMessages.class) == null) continue;
            try {
                String signatureHeader = request.getHeader("X-Line-Signature");
                byte[] payload = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
                CallbackRequest callbackRequest = this.webhookParser.handle(signatureHeader, payload);
                LineBotServerArgumentProcessor.setValue(request, callbackRequest);
                LineBotDestinationArgumentProcessor.setValue(request, callbackRequest);
                return true;
            }
            catch (WebhookParseException e) {
                log.info("LINE Bot callback exception: {}", (Object)e.getMessage());
                response.sendError(HttpStatus.BAD_REQUEST.value());
                try (PrintWriter writer = response.getWriter();){
                    writer.println(e.getMessage());
                }
                return false;
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

