/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot;

import com.linecorp.bot.client.LineClientConstants;
import com.linecorp.bot.spring.boot.BotPropertiesValidator;
import java.net.URI;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@BotPropertiesValidator.ValidBotProperties
@ConfigurationProperties(prefix="line.bot")
public class LineBotProperties {
    @NotNull
    private ChannelTokenSupplyMode channelTokenSupplyMode = ChannelTokenSupplyMode.FIXED;
    @Valid
    private String channelToken;
    @Valid
    @NotNull
    private String channelSecret;
    @Valid
    @NotNull
    private URI apiEndPoint = LineClientConstants.DEFAULT_API_END_POINT;
    @Valid
    @NotNull
    private URI blobEndPoint = LineClientConstants.DEFAULT_BLOB_END_POINT;
    @Valid
    @NotNull
    private long connectTimeout = 10000L;
    @Valid
    @NotNull
    private long readTimeout = 10000L;
    @Valid
    @NotNull
    private long writeTimeout = 10000L;
    @Valid
    @NotNull
    private Handler handler = new Handler();

    public ChannelTokenSupplyMode getChannelTokenSupplyMode() {
        return this.channelTokenSupplyMode;
    }

    public String getChannelToken() {
        return this.channelToken;
    }

    public String getChannelSecret() {
        return this.channelSecret;
    }

    public URI getApiEndPoint() {
        return this.apiEndPoint;
    }

    public URI getBlobEndPoint() {
        return this.blobEndPoint;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setChannelTokenSupplyMode(ChannelTokenSupplyMode channelTokenSupplyMode) {
        this.channelTokenSupplyMode = channelTokenSupplyMode;
    }

    public void setChannelToken(String channelToken) {
        this.channelToken = channelToken;
    }

    public void setChannelSecret(String channelSecret) {
        this.channelSecret = channelSecret;
    }

    public void setApiEndPoint(URI apiEndPoint) {
        this.apiEndPoint = apiEndPoint;
    }

    public void setBlobEndPoint(URI blobEndPoint) {
        this.blobEndPoint = blobEndPoint;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineBotProperties)) {
            return false;
        }
        LineBotProperties other = (LineBotProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChannelTokenSupplyMode this$channelTokenSupplyMode = this.getChannelTokenSupplyMode();
        ChannelTokenSupplyMode other$channelTokenSupplyMode = other.getChannelTokenSupplyMode();
        if (this$channelTokenSupplyMode == null ? other$channelTokenSupplyMode != null : !((Object)((Object)this$channelTokenSupplyMode)).equals((Object)other$channelTokenSupplyMode)) {
            return false;
        }
        String this$channelToken = this.getChannelToken();
        String other$channelToken = other.getChannelToken();
        if (this$channelToken == null ? other$channelToken != null : !this$channelToken.equals(other$channelToken)) {
            return false;
        }
        String this$channelSecret = this.getChannelSecret();
        String other$channelSecret = other.getChannelSecret();
        if (this$channelSecret == null ? other$channelSecret != null : !this$channelSecret.equals(other$channelSecret)) {
            return false;
        }
        URI this$apiEndPoint = this.getApiEndPoint();
        URI other$apiEndPoint = other.getApiEndPoint();
        if (this$apiEndPoint == null ? other$apiEndPoint != null : !((Object)this$apiEndPoint).equals(other$apiEndPoint)) {
            return false;
        }
        URI this$blobEndPoint = this.getBlobEndPoint();
        URI other$blobEndPoint = other.getBlobEndPoint();
        if (this$blobEndPoint == null ? other$blobEndPoint != null : !((Object)this$blobEndPoint).equals(other$blobEndPoint)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getWriteTimeout() != other.getWriteTimeout()) {
            return false;
        }
        Handler this$handler = this.getHandler();
        Handler other$handler = other.getHandler();
        return !(this$handler == null ? other$handler != null : !((Object)this$handler).equals(other$handler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LineBotProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChannelTokenSupplyMode $channelTokenSupplyMode = this.getChannelTokenSupplyMode();
        result = result * 59 + ($channelTokenSupplyMode == null ? 43 : ((Object)((Object)$channelTokenSupplyMode)).hashCode());
        String $channelToken = this.getChannelToken();
        result = result * 59 + ($channelToken == null ? 43 : $channelToken.hashCode());
        String $channelSecret = this.getChannelSecret();
        result = result * 59 + ($channelSecret == null ? 43 : $channelSecret.hashCode());
        URI $apiEndPoint = this.getApiEndPoint();
        result = result * 59 + ($apiEndPoint == null ? 43 : ((Object)$apiEndPoint).hashCode());
        URI $blobEndPoint = this.getBlobEndPoint();
        result = result * 59 + ($blobEndPoint == null ? 43 : ((Object)$blobEndPoint).hashCode());
        long $connectTimeout = this.getConnectTimeout();
        result = result * 59 + (int)($connectTimeout >>> 32 ^ $connectTimeout);
        long $readTimeout = this.getReadTimeout();
        result = result * 59 + (int)($readTimeout >>> 32 ^ $readTimeout);
        long $writeTimeout = this.getWriteTimeout();
        result = result * 59 + (int)($writeTimeout >>> 32 ^ $writeTimeout);
        Handler $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : ((Object)$handler).hashCode());
        return result;
    }

    public String toString() {
        return "LineBotProperties(channelTokenSupplyMode=" + (Object)((Object)this.getChannelTokenSupplyMode()) + ", channelToken=" + this.getChannelToken() + ", channelSecret=" + this.getChannelSecret() + ", apiEndPoint=" + this.getApiEndPoint() + ", blobEndPoint=" + this.getBlobEndPoint() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", handler=" + this.getHandler() + ")";
    }

    public static enum ChannelTokenSupplyMode {
        FIXED,
        SUPPLIER;

    }

    public static class Handler {
        boolean enabled = true;
        @NotNull
        URI path = URI.create("/callback");

        public boolean isEnabled() {
            return this.enabled;
        }

        public URI getPath() {
            return this.path;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setPath(URI path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Handler)) {
                return false;
            }
            Handler other = (Handler)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            URI this$path = this.getPath();
            URI other$path = other.getPath();
            return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Handler;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            URI $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            return result;
        }

        public String toString() {
            return "LineBotProperties.Handler(enabled=" + this.isEnabled() + ", path=" + this.getPath() + ")";
        }
    }
}

