/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot.interceptor;

import com.linecorp.bot.model.event.CallbackRequest;
import com.linecorp.bot.servlet.LineBotCallbackException;
import com.linecorp.bot.servlet.LineBotCallbackRequestParser;
import com.linecorp.bot.spring.boot.annotation.LineBotMessages;
import com.linecorp.bot.spring.boot.support.LineBotServerArgumentProcessor;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class LineBotServerInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LineBotServerInterceptor.class);
    @Autowired
    private LineBotCallbackRequestParser lineBotCallbackRequestParser;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        MethodParameter[] methodParameters;
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod hm = (HandlerMethod)handler;
        for (MethodParameter methodParameter : methodParameters = hm.getMethodParameters()) {
            if (methodParameter.getParameterAnnotation(LineBotMessages.class) == null) continue;
            try {
                CallbackRequest callbackRequest = this.lineBotCallbackRequestParser.handle(request);
                LineBotServerArgumentProcessor.setValue(request, callbackRequest);
                return true;
            }
            catch (LineBotCallbackException e) {
                log.info("LINE Bot callback exception: {}", (Object)e.getMessage());
                response.sendError(HttpStatus.BAD_REQUEST.value());
                try (PrintWriter writer = response.getWriter();){
                    writer.println(e.getMessage());
                }
                return false;
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

