/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot.support;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.linecorp.bot.client.LineMessagingClient;
import com.linecorp.bot.model.ReplyMessage;
import com.linecorp.bot.model.event.Event;
import com.linecorp.bot.model.event.ReplyEvent;
import com.linecorp.bot.model.message.Message;
import com.linecorp.bot.model.response.BotApiResponse;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

class ReplyByReturnValueConsumer
implements Consumer<Object> {
    private static final Logger log = LoggerFactory.getLogger(ReplyByReturnValueConsumer.class);
    private final LineMessagingClient lineMessagingClient;
    private final Event originalEvent;

    @Override
    public void accept(Object returnValue) {
        if (returnValue instanceof CompletableFuture) {
            ((CompletableFuture)returnValue).whenComplete(this::whenComplete);
        } else {
            this.acceptResult(returnValue);
        }
    }

    private void whenComplete(Object futureResult, Throwable throwable) {
        if (throwable != null) {
            log.error("Method return value waited but exception occurred in CompletedFuture", throwable);
            return;
        }
        this.acceptResult(futureResult);
    }

    private void acceptResult(Object returnValue) {
        if (returnValue instanceof Message) {
            this.reply(Collections.singletonList((Message)returnValue));
        } else if (returnValue instanceof List) {
            List returnValueAsList = (List)returnValue;
            if (returnValueAsList.isEmpty()) {
                return;
            }
            this.reply(ReplyByReturnValueConsumer.checkListContents(returnValueAsList));
        }
    }

    private void reply(List<Message> messages) {
        ReplyEvent replyEvent = (ReplyEvent)this.originalEvent;
        this.lineMessagingClient.replyMessage(new ReplyMessage(replyEvent.getReplyToken(), messages)).whenComplete(this::logging);
    }

    private void logging(BotApiResponse botApiResponse, Throwable throwable) {
        if (throwable == null) {
            log.debug("Reply message success. response = {}", (Object)botApiResponse);
        } else {
            log.warn("Reply message failed: {}", (Object)throwable.getMessage(), (Object)throwable);
        }
    }

    @VisibleForTesting
    static List<Message> checkListContents(List<?> list) {
        for (int i = 0; i < list.size(); ++i) {
            Message item = list.get(i);
            Preconditions.checkNotNull((Object)item, (String)"item is null. index = {} in {}", (int)i, list);
            Preconditions.checkArgument((boolean)(item instanceof Message), (String)"List contains not Message type object. type = {}", item.getClass());
        }
        return list;
    }

    ReplyByReturnValueConsumer(LineMessagingClient lineMessagingClient, Event originalEvent) {
        this.lineMessagingClient = lineMessagingClient;
        this.originalEvent = originalEvent;
    }

    public static ReplyByReturnValueConsumerBuilder builder() {
        return new ReplyByReturnValueConsumerBuilder();
    }

    public static class ReplyByReturnValueConsumerBuilder {
        private LineMessagingClient lineMessagingClient;
        private Event originalEvent;

        ReplyByReturnValueConsumerBuilder() {
        }

        public ReplyByReturnValueConsumerBuilder lineMessagingClient(LineMessagingClient lineMessagingClient) {
            this.lineMessagingClient = lineMessagingClient;
            return this;
        }

        public ReplyByReturnValueConsumerBuilder originalEvent(Event originalEvent) {
            this.originalEvent = originalEvent;
            return this;
        }

        public ReplyByReturnValueConsumer build() {
            return new ReplyByReturnValueConsumer(this.lineMessagingClient, this.originalEvent);
        }

        public String toString() {
            return "ReplyByReturnValueConsumer.ReplyByReturnValueConsumerBuilder(lineMessagingClient=" + this.lineMessagingClient + ", originalEvent=" + this.originalEvent + ")";
        }
    }

    @Component
    static class Factory {
        private final LineMessagingClient lineMessagingClient;

        @Autowired
        Factory(LineMessagingClient lineMessagingClient) {
            this.lineMessagingClient = lineMessagingClient;
        }

        ReplyByReturnValueConsumer createForEvent(Event event) {
            return ReplyByReturnValueConsumer.builder().lineMessagingClient(this.lineMessagingClient).originalEvent(event).build();
        }
    }
}

