/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot;

import com.linecorp.bot.spring.boot.LineBotProperties;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

public class BotPropertiesValidator
implements ConstraintValidator<ValidBotProperties, LineBotProperties> {
    public void initialize(ValidBotProperties constraintAnnotation) {
    }

    public boolean isValid(LineBotProperties value, ConstraintValidatorContext context) {
        switch (value.getChannelTokenSupplyMode()) {
            case FIXED: {
                if (value.getChannelToken() != null) {
                    return true;
                }
                context.buildConstraintViolationWithTemplate("channelToken is null").addPropertyNode("channelToken").addConstraintViolation();
                return false;
            }
            case SUPPLIER: {
                if (value.getChannelToken() == null) {
                    return true;
                }
                context.buildConstraintViolationWithTemplate("channelToken should be null if channelTokenSupplyMode = SUPPLIER").addPropertyNode("channelToken").addConstraintViolation();
                return false;
            }
        }
        throw new IllegalStateException("Not implemented channelTokenSupplyMode.");
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Constraint(validatedBy={BotPropertiesValidator.class})
    public static @interface ValidBotProperties {
        public Class<?>[] groups() default {};

        public String message() default "";

        public Class<? extends Payload>[] payload() default {};
    }
}

