/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot;

import com.linecorp.bot.client.ChannelManagementSyncClient;
import com.linecorp.bot.client.ChannelTokenSupplier;
import com.linecorp.bot.client.FixedChannelTokenSupplier;
import com.linecorp.bot.client.LineBlobClient;
import com.linecorp.bot.client.LineMessagingClient;
import com.linecorp.bot.client.ManageAudienceBlobClient;
import com.linecorp.bot.client.ManageAudienceClient;
import com.linecorp.bot.spring.boot.LineBotProperties;
import com.linecorp.bot.spring.boot.LineBotWebMvcConfigurer;
import com.linecorp.bot.spring.boot.support.LineMessageHandlerSupport;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureAfter(value={LineBotWebMvcConfigurer.class})
@EnableConfigurationProperties(value={LineBotProperties.class})
@Import(value={LineMessageHandlerSupport.class})
public class LineBotAutoConfiguration {
    private final LineBotProperties lineBotProperties;

    public LineBotAutoConfiguration(LineBotProperties lineBotProperties) {
        this.lineBotProperties = lineBotProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={ChannelTokenSupplier.class})
    public ChannelTokenSupplier channelTokenSupplier() {
        String channelToken = this.lineBotProperties.getChannelToken();
        return FixedChannelTokenSupplier.of((String)channelToken);
    }

    @Bean
    @ConditionalOnMissingBean
    public LineMessagingClient lineMessagingClient(ChannelTokenSupplier channelTokenSupplier) {
        return LineMessagingClient.builder((ChannelTokenSupplier)channelTokenSupplier).apiEndPoint(this.lineBotProperties.getApiEndPoint()).blobEndPoint(this.lineBotProperties.getBlobEndPoint()).connectTimeout(this.lineBotProperties.getConnectTimeout()).readTimeout(this.lineBotProperties.getReadTimeout()).writeTimeout(this.lineBotProperties.getWriteTimeout()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public LineBlobClient lineBlobClient(ChannelTokenSupplier channelTokenSupplier) {
        return LineBlobClient.builder((ChannelTokenSupplier)channelTokenSupplier).apiEndPoint(this.lineBotProperties.getBlobEndPoint()).connectTimeout(this.lineBotProperties.getConnectTimeout()).readTimeout(this.lineBotProperties.getReadTimeout()).writeTimeout(this.lineBotProperties.getWriteTimeout()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public ChannelManagementSyncClient channelManagementClient(ChannelTokenSupplier channelTokenSupplier) {
        return ChannelManagementSyncClient.builder((ChannelTokenSupplier)channelTokenSupplier).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public ManageAudienceBlobClient manageAudienceBlobClient(ChannelTokenSupplier channelTokenSupplier) {
        return ManageAudienceBlobClient.builder().channelTokenSupplier(channelTokenSupplier).apiEndPoint(this.lineBotProperties.getBlobEndPoint()).connectTimeout(this.lineBotProperties.getConnectTimeout()).readTimeout(this.lineBotProperties.getReadTimeout()).writeTimeout(this.lineBotProperties.getWriteTimeout()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public ManageAudienceClient manageAudienceClient(ChannelTokenSupplier channelTokenSupplier) {
        return ManageAudienceClient.builder().channelTokenSupplier(channelTokenSupplier).apiEndPoint(this.lineBotProperties.getApiEndPoint()).connectTimeout(this.lineBotProperties.getConnectTimeout()).readTimeout(this.lineBotProperties.getReadTimeout()).writeTimeout(this.lineBotProperties.getWriteTimeout()).build();
    }
}

