/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.spring.boot.support;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.linecorp.bot.model.event.Event;
import com.linecorp.bot.model.event.MessageEvent;
import com.linecorp.bot.model.event.ReplyEvent;
import com.linecorp.bot.model.event.message.MessageContent;
import com.linecorp.bot.spring.boot.annotation.EventMapping;
import com.linecorp.bot.spring.boot.annotation.LineBotDestination;
import com.linecorp.bot.spring.boot.annotation.LineBotMessages;
import com.linecorp.bot.spring.boot.annotation.LineMessageHandler;
import com.linecorp.bot.spring.boot.support.ReplyByReturnValueConsumer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Import(value={ReplyByReturnValueConsumer.Factory.class})
@ConditionalOnProperty(name={"line.bot.handler.enabled"}, havingValue="true", matchIfMissing=true)
public class LineMessageHandlerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LineMessageHandlerSupport.class);
    private static final Comparator<HandlerMethod> HANDLER_METHOD_PRIORITY_COMPARATOR = Comparator.comparing(HandlerMethod::getPriority).reversed();
    private final ReplyByReturnValueConsumer.Factory returnValueConsumerFactory;
    private final ConfigurableApplicationContext applicationContext;
    volatile List<HandlerMethod> eventConsumerList;

    @Autowired
    public LineMessageHandlerSupport(ReplyByReturnValueConsumer.Factory returnValueConsumerFactory, ConfigurableApplicationContext applicationContext) {
        this.returnValueConsumerFactory = returnValueConsumerFactory;
        this.applicationContext = applicationContext;
        applicationContext.addApplicationListener(event -> {
            if (event instanceof ContextRefreshedEvent) {
                this.refresh();
            }
        });
    }

    @VisibleForTesting
    void refresh() {
        Map handlerBeanMap = this.applicationContext.getBeansWithAnnotation(LineMessageHandler.class);
        List<HandlerMethod> collect = handlerBeanMap.values().stream().flatMap(bean -> {
            Method[] uniqueDeclaredMethods = ReflectionUtils.getUniqueDeclaredMethods(bean.getClass());
            return Arrays.stream(uniqueDeclaredMethods).map(method -> this.getMethodHandlerMethodFunction(bean, (Method)method)).filter(Objects::nonNull);
        }).sorted(HANDLER_METHOD_PRIORITY_COMPARATOR).collect(Collectors.toList());
        log.info("Registered LINE Messaging API event handler: count = {}", (Object)collect.size());
        collect.forEach(item -> log.info("Mapped \"{}\" onto {}", item.getSupportType(), (Object)item.getHandler().toGenericString()));
        this.eventConsumerList = collect;
    }

    private HandlerMethod getMethodHandlerMethodFunction(Object consumer, Method method) {
        EventMapping mapping = (EventMapping)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, EventMapping.class);
        if (mapping == null) {
            return null;
        }
        return new HandlerMethod(consumer, method, mapping);
    }

    @PostMapping(value={"${line.bot.handler.path:/callback}"})
    public void callback(@LineBotDestination String destination, @LineBotMessages List<Event> events) {
        events.forEach(event -> this.dispatch(destination, (Event)event));
    }

    @VisibleForTesting
    void dispatch(String destination, Event event) {
        try {
            this.dispatchInternal(destination, event);
        }
        catch (InvocationTargetException e) {
            log.error("InvocationTargetException occurred.", (Throwable)e);
        }
        catch (Error | Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private void dispatchInternal(String destination, Event event) throws Exception {
        HandlerMethod handlerMethod = this.eventConsumerList.stream().filter(consumer -> consumer.getSupportType().test(event)).findFirst().orElseThrow(() -> new UnsupportedOperationException("Unsupported event type. " + event));
        Object returnValue = handlerMethod.invoke(destination, event);
        this.handleReturnValue(event, returnValue);
    }

    private void handleReturnValue(Event event, Object returnValue) {
        if (returnValue != null) {
            this.returnValueConsumerFactory.createForEvent(event).accept(returnValue);
        }
    }

    static final class HandlerMethod {
        private final Predicate<Event> supportType;
        private final Object object;
        private final Method handler;
        private final int priority;

        HandlerMethod(Object object, Method handler, EventMapping mapping) {
            this.object = object;
            this.handler = handler;
            int parameterCount = handler.getParameterCount();
            if (parameterCount == 1) {
                Type type = handler.getGenericParameterTypes()[0];
                this.supportType = new EventPredicate(type);
                this.priority = this.calcPriority(mapping, type);
            } else if (parameterCount == 2) {
                Annotation[] parameterAnnotations = handler.getParameterAnnotations()[0];
                Preconditions.checkState((Arrays.stream(parameterAnnotations).filter(it -> it instanceof LineBotDestination).count() == 1L ? 1 : 0) != 0, (Object)"1st argument of the event hnadler should have @LineBotDestination annotation when the method have 2 arguments.");
                Type type = handler.getGenericParameterTypes()[1];
                this.supportType = new EventPredicate(type);
                this.priority = this.calcPriority(mapping, type);
            } else {
                throw new IllegalStateException("Number of parameter should be 1 or 2. But " + Arrays.toString(handler.getParameterTypes()));
            }
        }

        private int calcPriority(EventMapping mapping, Type type) {
            if (mapping.priority() != -1) {
                return mapping.priority();
            }
            if (type == Event.class) {
                return 0;
            }
            if (type instanceof Class) {
                return ((Class)type).isInterface() ? 100 : 200;
            }
            if (type instanceof ParameterizedType) {
                return 300;
            }
            throw new IllegalStateException();
        }

        Object invoke(String destination, Event event) throws Exception {
            int count = this.handler.getParameterCount();
            if (count == 1) {
                return this.handler.invoke(this.object, event);
            }
            if (count == 2) {
                return this.handler.invoke(this.object, destination, event);
            }
            throw new IllegalStateException();
        }

        @Generated
        public Predicate<Event> getSupportType() {
            return this.supportType;
        }

        @Generated
        public Object getObject() {
            return this.object;
        }

        @Generated
        public Method getHandler() {
            return this.handler;
        }

        @Generated
        public int getPriority() {
            return this.priority;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HandlerMethod)) {
                return false;
            }
            HandlerMethod other = (HandlerMethod)o;
            if (this.getPriority() != other.getPriority()) {
                return false;
            }
            Predicate<Event> this$supportType = this.getSupportType();
            Predicate<Event> other$supportType = other.getSupportType();
            if (this$supportType == null ? other$supportType != null : !this$supportType.equals(other$supportType)) {
                return false;
            }
            Object this$object = this.getObject();
            Object other$object = other.getObject();
            if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
                return false;
            }
            Method this$handler = this.getHandler();
            Method other$handler = other.getHandler();
            return !(this$handler == null ? other$handler != null : !((Object)this$handler).equals(other$handler));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPriority();
            Predicate<Event> $supportType = this.getSupportType();
            result = result * 59 + ($supportType == null ? 43 : $supportType.hashCode());
            Object $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            Method $handler = this.getHandler();
            result = result * 59 + ($handler == null ? 43 : ((Object)$handler).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LineMessageHandlerSupport.HandlerMethod(supportType=" + this.getSupportType() + ", object=" + this.getObject() + ", handler=" + this.getHandler() + ", priority=" + this.getPriority() + ")";
        }
    }

    private static class EventPredicate
    implements Predicate<Event> {
        private final Class<?> supportEvent;
        private final Class<? extends MessageContent> messageContentType;

        EventPredicate(Type mapping) {
            if (mapping == ReplyEvent.class) {
                this.supportEvent = ReplyEvent.class;
                this.messageContentType = null;
            } else if (mapping instanceof Class) {
                Preconditions.checkState((boolean)Event.class.isAssignableFrom((Class)mapping), (String)"Handler argument type should BE-A Event. But {}", mapping.getClass());
                this.supportEvent = (Class)mapping;
                this.messageContentType = null;
            } else {
                ParameterizedType parameterizedType = (ParameterizedType)mapping;
                this.supportEvent = (Class)parameterizedType.getRawType();
                this.messageContentType = (Class)((ParameterizedType)mapping).getActualTypeArguments()[0];
            }
        }

        @Override
        public boolean test(Event event) {
            return this.supportEvent.isAssignableFrom(event.getClass()) && (this.messageContentType == null || event instanceof MessageEvent && EventPredicate.filterByType(this.messageContentType, ((MessageEvent)event).getMessage()));
        }

        private static boolean filterByType(Class<?> clazz, Object content) {
            return clazz.isAssignableFrom(content.getClass());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            if (this.messageContentType != null) {
                sb.append(MessageEvent.class.getSimpleName()).append('<').append(this.messageContentType.getSimpleName()).append('>');
            } else {
                sb.append(this.supportEvent.getSimpleName());
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

