/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.webhook.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.linecorp.bot.webhook.model.MessageContent;
import java.util.List;

@JsonTypeName(value="sticker")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record StickerMessageContent(@JsonProperty(value="id") String id, @JsonProperty(value="packageId") String packageId, @JsonProperty(value="stickerId") String stickerId, @JsonProperty(value="stickerResourceType") StickerResourceType stickerResourceType, @JsonProperty(value="keywords") List<String> keywords, @JsonProperty(value="text") String text, @JsonProperty(value="quoteToken") String quoteToken, @JsonProperty(value="quotedMessageId") String quotedMessageId) implements MessageContent
{

    public static enum StickerResourceType {
        STATIC,
        ANIMATION,
        SOUND,
        ANIMATION_SOUND,
        POPUP,
        POPUP_SOUND,
        CUSTOM,
        MESSAGE,
        NAME_TEXT,
        PER_STICKER_TEXT,
        UNDEFINED;

    }

    public static class Builder {
        private String id;
        private String packageId;
        private String stickerId;
        private StickerResourceType stickerResourceType;
        private List<String> keywords;
        private String text;
        private String quoteToken;
        private String quotedMessageId;

        public Builder(String id, String packageId, String stickerId, StickerResourceType stickerResourceType, String quoteToken) {
            this.id = id;
            this.packageId = packageId;
            this.stickerId = stickerId;
            this.stickerResourceType = stickerResourceType;
            this.quoteToken = quoteToken;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder quotedMessageId(String quotedMessageId) {
            this.quotedMessageId = quotedMessageId;
            return this;
        }

        public StickerMessageContent build() {
            return new StickerMessageContent(this.id, this.packageId, this.stickerId, this.stickerResourceType, this.keywords, this.text, this.quoteToken, this.quotedMessageId);
        }
    }
}

