/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.liff.client;

import com.linecorp.bot.client.base.ApiAuthenticatedClientBuilder;
import com.linecorp.bot.client.base.ExceptionBuilder;
import com.linecorp.bot.client.base.Result;
import com.linecorp.bot.client.base.channel.ChannelTokenSupplier;
import com.linecorp.bot.liff.client.LiffExceptionBuilder;
import com.linecorp.bot.liff.model.AddLiffAppRequest;
import com.linecorp.bot.liff.model.AddLiffAppResponse;
import com.linecorp.bot.liff.model.GetAllLiffAppsResponse;
import com.linecorp.bot.liff.model.UpdateLiffAppRequest;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;

public interface LiffClient {
    @POST(value="/liff/v1/apps")
    public CompletableFuture<Result<AddLiffAppResponse>> addLIFFApp(@Body AddLiffAppRequest var1);

    @DELETE(value="/liff/v1/apps/{liffId}")
    public CompletableFuture<Result<Void>> deleteLIFFApp(@Path(value="liffId") String var1);

    @GET(value="/liff/v1/apps")
    public CompletableFuture<Result<GetAllLiffAppsResponse>> getAllLIFFApps();

    @PUT(value="/liff/v1/apps/{liffId}")
    public CompletableFuture<Result<Void>> updateLIFFApp(@Path(value="liffId") String var1, @Body UpdateLiffAppRequest var2);

    public static ApiAuthenticatedClientBuilder<LiffClient> builder(String channelToken) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api.line.me"), LiffClient.class, (ExceptionBuilder)new LiffExceptionBuilder(), channelToken);
    }

    public static ApiAuthenticatedClientBuilder<LiffClient> builder(ChannelTokenSupplier channelTokenSupplier) {
        return new ApiAuthenticatedClientBuilder(URI.create("https://api.line.me"), LiffClient.class, (ExceptionBuilder)new LiffExceptionBuilder(), channelTokenSupplier);
    }

    @Deprecated
    default public CompletableFuture<Result<GetAllLiffAppsResponse>> liffV1AppsGet() {
        return this.getAllLIFFApps();
    }

    @Deprecated
    default public CompletableFuture<Result<Void>> liffV1AppsLiffIdDelete(@Path(value="liffId") String liffId) {
        return this.deleteLIFFApp(liffId);
    }

    @Deprecated
    default public CompletableFuture<Result<Void>> liffV1AppsLiffIdPut(@Path(value="liffId") String liffId, @Body UpdateLiffAppRequest updateLiffAppRequest) {
        return this.updateLIFFApp(liffId, updateLiffAppRequest);
    }

    @Deprecated
    default public CompletableFuture<Result<AddLiffAppResponse>> liffV1AppsPost(@Body AddLiffAppRequest addLiffAppRequest) {
        return this.addLIFFApp(addLiffAppRequest);
    }
}

