/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.armeria.legacy;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.thrift.ThriftFuture;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.client.AbstractCentralDogma;
import com.linecorp.centraldogma.client.RepositoryInfo;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.PushResult;
import com.linecorp.centraldogma.common.QueryExecutionException;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.futures.CompletableFutures;
import com.linecorp.centraldogma.internal.shaded.guava.base.Converter;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import com.linecorp.centraldogma.internal.thrift.Author;
import com.linecorp.centraldogma.internal.thrift.AuthorConverter;
import com.linecorp.centraldogma.internal.thrift.CentralDogmaException;
import com.linecorp.centraldogma.internal.thrift.CentralDogmaService;
import com.linecorp.centraldogma.internal.thrift.Change;
import com.linecorp.centraldogma.internal.thrift.ChangeConverter;
import com.linecorp.centraldogma.internal.thrift.Comment;
import com.linecorp.centraldogma.internal.thrift.CommitConverter;
import com.linecorp.centraldogma.internal.thrift.EntryConverter;
import com.linecorp.centraldogma.internal.thrift.Markup;
import com.linecorp.centraldogma.internal.thrift.MarkupConverter;
import com.linecorp.centraldogma.internal.thrift.MergeQueryConverter;
import com.linecorp.centraldogma.internal.thrift.Project;
import com.linecorp.centraldogma.internal.thrift.PushResultConverter;
import com.linecorp.centraldogma.internal.thrift.Query;
import com.linecorp.centraldogma.internal.thrift.QueryConverter;
import com.linecorp.centraldogma.internal.thrift.Repository;
import com.linecorp.centraldogma.internal.thrift.RevisionConverter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;

final class LegacyCentralDogma
extends AbstractCentralDogma {
    private final CentralDogmaService.AsyncIface client;

    LegacyCentralDogma(ScheduledExecutorService blockingTaskExecutor, CentralDogmaService.AsyncIface client) {
        super(blockingTaskExecutor);
        this.client = Objects.requireNonNull(client, "client");
    }

    public CompletableFuture<Void> createProject(String projectName) {
        return LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectName(projectName);
            this.client.createProject(projectName, (AsyncMethodCallback)callback);
        });
    }

    public CompletableFuture<Void> removeProject(String projectName) {
        return LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectName(projectName);
            this.client.removeProject(projectName, (AsyncMethodCallback)callback);
        });
    }

    public CompletableFuture<Void> purgeProject(String projectName) {
        return LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectName(projectName);
            this.client.purgeProject(projectName, (AsyncMethodCallback)callback);
        });
    }

    public CompletableFuture<Void> unremoveProject(String projectName) {
        return LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectName(projectName);
            this.client.unremoveProject(projectName, (AsyncMethodCallback)callback);
        });
    }

    public CompletableFuture<Set<String>> listProjects() {
        CompletableFuture future = LegacyCentralDogma.run(arg_0 -> ((CentralDogmaService.AsyncIface)this.client).listProjects(arg_0));
        return future.thenApply(list -> LegacyCentralDogma.convertToSet(list, Project::getName));
    }

    public CompletableFuture<Set<String>> listRemovedProjects() {
        return LegacyCentralDogma.run(arg_0 -> ((CentralDogmaService.AsyncIface)this.client).listRemovedProjects(arg_0));
    }

    public CompletableFuture<Void> createRepository(String projectName, String repositoryName) {
        return LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            this.client.createRepository(projectName, repositoryName, (AsyncMethodCallback)callback);
        });
    }

    public CompletableFuture<Void> removeRepository(String projectName, String repositoryName) {
        return LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            this.client.removeRepository(projectName, repositoryName, (AsyncMethodCallback)callback);
        });
    }

    public CompletableFuture<Void> purgeRepository(String projectName, String repositoryName) {
        return LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            this.client.purgeRepository(projectName, repositoryName, (AsyncMethodCallback)callback);
        });
    }

    public CompletableFuture<Void> unremoveRepository(String projectName, String repositoryName) {
        return LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            this.client.unremoveRepository(projectName, repositoryName, (AsyncMethodCallback)callback);
        });
    }

    public CompletableFuture<Map<String, RepositoryInfo>> listRepositories(String projectName) {
        CompletableFuture future = LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectName(projectName);
            this.client.listRepositories(projectName, (AsyncMethodCallback)callback);
        });
        return future.thenApply(list -> LegacyCentralDogma.convertToMap(list, Function.identity(), Repository::getName, r -> new RepositoryInfo(r.getName(), (Revision)RevisionConverter.TO_MODEL.convert((Object)r.getHead().getRevision()))));
    }

    public CompletableFuture<Set<String>> listRemovedRepositories(String projectName) {
        return LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectName(projectName);
            this.client.listRemovedRepositories(projectName, (AsyncMethodCallback)callback);
        });
    }

    public CompletableFuture<Revision> normalizeRevision(String projectName, String repositoryName, Revision revision) {
        CompletableFuture future = LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            Objects.requireNonNull(revision, "revision");
            this.client.normalizeRevision(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)revision), (AsyncMethodCallback)callback);
        });
        return future.thenApply(arg_0 -> ((Converter)RevisionConverter.TO_MODEL).convert(arg_0));
    }

    public CompletableFuture<Map<String, EntryType>> listFiles(String projectName, String repositoryName, Revision revision, String pathPattern) {
        CompletableFuture future = LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            Objects.requireNonNull(revision, "revision");
            Util.validatePathPattern((String)pathPattern, (String)"pathPattern");
            this.client.listFiles(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)revision), pathPattern, (AsyncMethodCallback)callback);
        });
        return future.thenApply(list -> (Map)list.stream().collect(ImmutableMap.toImmutableMap(com.linecorp.centraldogma.internal.thrift.Entry::getPath, e -> EntryConverter.convertEntryType((com.linecorp.centraldogma.internal.thrift.EntryType)e.getType()))));
    }

    public <T> CompletableFuture<Entry<T>> getFile(String projectName, String repositoryName, Revision revision, com.linecorp.centraldogma.common.Query<T> query) {
        return this.maybeNormalizeRevision(projectName, repositoryName, revision).thenCompose(normRev -> {
            CompletableFuture future = LegacyCentralDogma.run(callback -> {
                Objects.requireNonNull(query, "query");
                this.client.getFile(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert(normRev), (Query)QueryConverter.TO_DATA.convert((Object)query), (AsyncMethodCallback)callback);
            });
            return future.thenApply(r -> {
                if (r == null) {
                    return null;
                }
                return LegacyCentralDogma.toEntry(query, normRev, query.type(), r.getContent(), r.getType());
            });
        });
    }

    private static <T> Entry<T> toEntry(com.linecorp.centraldogma.common.Query<T> query, Revision normRev, QueryType queryType, String content, com.linecorp.centraldogma.internal.thrift.EntryType receivedEntryType) {
        switch (queryType) {
            case IDENTITY_TEXT: {
                return LegacyCentralDogma.entryAsText(query, normRev, content);
            }
            case IDENTITY_JSON: 
            case JSON_PATH: {
                if (receivedEntryType != com.linecorp.centraldogma.internal.thrift.EntryType.JSON) {
                    throw new com.linecorp.centraldogma.common.CentralDogmaException("invalid entry type. entry type: " + receivedEntryType + " (expected: " + queryType + ')');
                }
                return LegacyCentralDogma.entryAsJson(query, normRev, content);
            }
            case IDENTITY: {
                switch (receivedEntryType) {
                    case JSON: {
                        return LegacyCentralDogma.entryAsJson(query, normRev, content);
                    }
                    case TEXT: {
                        return LegacyCentralDogma.entryAsText(query, normRev, content);
                    }
                    case DIRECTORY: {
                        return (Entry)Util.unsafeCast((Object)Entry.ofDirectory((Revision)normRev, (String)query.path()));
                    }
                }
            }
        }
        throw new Error();
    }

    private static <T> Entry<T> entryAsJson(com.linecorp.centraldogma.common.Query<T> query, Revision normRev, String content) {
        try {
            return (Entry)Util.unsafeCast((Object)Entry.ofJson((Revision)normRev, (String)query.path(), (JsonNode)Jackson.readTree((String)content)));
        }
        catch (IOException e) {
            throw new com.linecorp.centraldogma.common.CentralDogmaException("failed to parse the query result: " + query, (Throwable)e);
        }
    }

    private static <T> Entry<T> entryAsText(com.linecorp.centraldogma.common.Query<T> query, Revision normRev, String content) {
        return (Entry)Util.unsafeCast((Object)Entry.ofText((Revision)normRev, (String)query.path(), (String)content));
    }

    public CompletableFuture<Map<String, Entry<?>>> getFiles(String projectName, String repositoryName, Revision revision, String pathPattern) {
        return this.maybeNormalizeRevision(projectName, repositoryName, revision).thenCompose(normRev -> {
            CompletableFuture future = LegacyCentralDogma.run(callback -> {
                Util.validatePathPattern((String)pathPattern, (String)"pathPattern");
                this.client.getFiles(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert(normRev), pathPattern, (AsyncMethodCallback)callback);
            });
            return future.thenApply(list -> LegacyCentralDogma.convertToMap(list, e -> EntryConverter.convert((Revision)normRev, (com.linecorp.centraldogma.internal.thrift.Entry)e), Entry::path, Function.identity()));
        });
    }

    public <T> CompletableFuture<MergedEntry<T>> mergeFiles(String projectName, String repositoryName, Revision revision, MergeQuery<T> mergeQuery) {
        CompletableFuture future = LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            Objects.requireNonNull(revision, "revision");
            Objects.requireNonNull(mergeQuery, "mergeQuery");
            this.client.mergeFiles(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)revision), (com.linecorp.centraldogma.internal.thrift.MergeQuery)MergeQueryConverter.TO_DATA.convert((Object)mergeQuery), (AsyncMethodCallback)callback);
        });
        return future.thenApply(entry -> {
            EntryType entryType = EntryConverter.convertEntryType((com.linecorp.centraldogma.internal.thrift.EntryType)entry.getType());
            assert (entryType != null);
            switch (entryType) {
                case JSON: {
                    try {
                        MergedEntry converted = MergedEntry.of((Revision)((Revision)RevisionConverter.TO_MODEL.convert((Object)entry.revision)), (EntryType)entryType, (Object)Jackson.readTree((String)entry.content), (Iterable)entry.paths);
                        return converted;
                    }
                    catch (IOException e) {
                        throw new com.linecorp.centraldogma.common.CentralDogmaException("failed to parse the content: " + entry.content, (Throwable)e);
                    }
                }
            }
            throw new Error("unsupported entry type: " + entryType);
        });
    }

    public CompletableFuture<List<Commit>> getHistory(String projectName, String repositoryName, Revision from, Revision to, String pathPattern) {
        CompletableFuture future = LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            Objects.requireNonNull(from, "from");
            Objects.requireNonNull(to, "to");
            Util.validatePathPattern((String)pathPattern, (String)"pathPattern");
            this.client.getHistory(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)from), (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)to), pathPattern, (AsyncMethodCallback)callback);
        });
        return future.thenApply(list -> LegacyCentralDogma.convertToList(list, arg_0 -> ((Converter)CommitConverter.TO_MODEL).convert(arg_0)));
    }

    public <T> CompletableFuture<com.linecorp.centraldogma.common.Change<T>> getDiff(String projectName, String repositoryName, Revision from, Revision to, com.linecorp.centraldogma.common.Query<T> query) {
        CompletableFuture future = LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            Objects.requireNonNull(from, "from");
            Objects.requireNonNull(to, "to");
            Objects.requireNonNull(query, "query");
            this.client.diffFile(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)from), (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)to), (Query)QueryConverter.TO_DATA.convert((Object)query), (AsyncMethodCallback)callback);
        });
        return future.thenApply(r -> {
            com.linecorp.centraldogma.common.Change converted;
            if (r == null) {
                return null;
            }
            switch (r.getType()) {
                case UPSERT_JSON: {
                    converted = (com.linecorp.centraldogma.common.Change)Util.unsafeCast((Object)com.linecorp.centraldogma.common.Change.ofJsonUpsert((String)query.path(), (String)r.getContent()));
                    break;
                }
                case UPSERT_TEXT: {
                    converted = (com.linecorp.centraldogma.common.Change)Util.unsafeCast((Object)com.linecorp.centraldogma.common.Change.ofTextUpsert((String)query.path(), (String)r.getContent()));
                    break;
                }
                case REMOVE: {
                    converted = (com.linecorp.centraldogma.common.Change)Util.unsafeCast((Object)com.linecorp.centraldogma.common.Change.ofRemoval((String)query.path()));
                    break;
                }
                case RENAME: {
                    converted = (com.linecorp.centraldogma.common.Change)Util.unsafeCast((Object)com.linecorp.centraldogma.common.Change.ofRename((String)query.path(), (String)r.getContent()));
                    break;
                }
                case APPLY_JSON_PATCH: {
                    converted = (com.linecorp.centraldogma.common.Change)Util.unsafeCast((Object)com.linecorp.centraldogma.common.Change.ofJsonPatch((String)query.path(), (String)r.getContent()));
                    break;
                }
                case APPLY_TEXT_PATCH: {
                    converted = (com.linecorp.centraldogma.common.Change)Util.unsafeCast((Object)com.linecorp.centraldogma.common.Change.ofTextPatch((String)query.path(), (String)r.getContent()));
                    break;
                }
                default: {
                    throw new Error("unknown change type: " + r.getType());
                }
            }
            return converted;
        });
    }

    public CompletableFuture<List<com.linecorp.centraldogma.common.Change<?>>> getDiffs(String projectName, String repositoryName, Revision from, Revision to, String pathPattern) {
        CompletableFuture future = LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            Objects.requireNonNull(from, "from");
            Objects.requireNonNull(to, "to");
            Util.validatePathPattern((String)pathPattern, (String)"pathPattern");
            this.client.getDiffs(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)from), (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)to), pathPattern, (AsyncMethodCallback)callback);
        });
        return future.thenApply(list -> LegacyCentralDogma.convertToList(list, arg_0 -> ((Converter)ChangeConverter.TO_MODEL).convert(arg_0)));
    }

    public CompletableFuture<List<com.linecorp.centraldogma.common.Change<?>>> getPreviewDiffs(String projectName, String repositoryName, Revision baseRevision, Iterable<? extends com.linecorp.centraldogma.common.Change<?>> changes) {
        CompletableFuture future = LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            Objects.requireNonNull(baseRevision, "baseRevision");
            Objects.requireNonNull(changes, "changes");
            this.client.getPreviewDiffs(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)baseRevision), LegacyCentralDogma.convertToList(changes, arg_0 -> ((Converter)ChangeConverter.TO_DATA).convert(arg_0)), (AsyncMethodCallback)callback);
        });
        return future.thenApply(LegacyCentralDogma::convertToChangesModel);
    }

    public CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, String summary, String detail, com.linecorp.centraldogma.common.Markup markup, Iterable<? extends com.linecorp.centraldogma.common.Change<?>> changes) {
        return this.push(projectName, repositoryName, baseRevision, com.linecorp.centraldogma.common.Author.UNKNOWN, summary, detail, markup, changes);
    }

    public CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, com.linecorp.centraldogma.common.Author author, String summary, String detail, com.linecorp.centraldogma.common.Markup markup, Iterable<? extends com.linecorp.centraldogma.common.Change<?>> changes) {
        CompletableFuture future = LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            Objects.requireNonNull(baseRevision, "baseRevision");
            Objects.requireNonNull(author, "author");
            Objects.requireNonNull(summary, "summary");
            Objects.requireNonNull(detail, "detail");
            Objects.requireNonNull(markup, "markup");
            Objects.requireNonNull(changes, "changes");
            Preconditions.checkArgument((!Iterables.isEmpty((Iterable)changes) ? 1 : 0) != 0, (Object)"changes is empty.");
            this.client.push(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)baseRevision), (Author)AuthorConverter.TO_DATA.convert((Object)author), summary, new Comment(detail).setMarkup((Markup)MarkupConverter.TO_DATA.convert((Object)markup)), LegacyCentralDogma.convertToList(changes, arg_0 -> ((Converter)ChangeConverter.TO_DATA).convert(arg_0)), (AsyncMethodCallback)callback);
        });
        return future.thenApply(arg_0 -> ((Converter)PushResultConverter.TO_MODEL).convert(arg_0));
    }

    public CompletableFuture<Revision> watchRepository(String projectName, String repositoryName, Revision lastKnownRevision, String pathPattern, long timeoutMillis) {
        CompletableFuture future = LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
            Util.validatePathPattern((String)pathPattern, (String)"pathPattern");
            this.client.watchRepository(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)lastKnownRevision), pathPattern, timeoutMillis, (AsyncMethodCallback)callback);
        });
        return future.thenApply(r -> {
            if (r == null) {
                return null;
            }
            return (Revision)RevisionConverter.TO_MODEL.convert((Object)r.getRevision());
        });
    }

    public <T> CompletableFuture<Entry<T>> watchFile(String projectName, String repositoryName, Revision lastKnownRevision, com.linecorp.centraldogma.common.Query<T> query, long timeoutMillis) {
        CompletableFuture future = LegacyCentralDogma.run(callback -> {
            LegacyCentralDogma.validateProjectAndRepositoryName(projectName, repositoryName);
            Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
            Objects.requireNonNull(query, "query");
            this.client.watchFile(projectName, repositoryName, (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)lastKnownRevision), (Query)QueryConverter.TO_DATA.convert((Object)query), timeoutMillis, (AsyncMethodCallback)callback);
        });
        return future.thenApply(r -> {
            if (r == null) {
                return null;
            }
            Revision revision = (Revision)RevisionConverter.TO_MODEL.convert((Object)r.getRevision());
            if (revision == null) {
                return null;
            }
            return LegacyCentralDogma.toEntry(query, revision, query.type(), r.getContent(), r.getType());
        });
    }

    private static void validateProjectName(String projectName) {
        Util.validateProjectName((String)projectName, (String)"projectName");
    }

    private static void validateProjectAndRepositoryName(String projectName, String repositoryName) {
        LegacyCentralDogma.validateProjectName(projectName);
        Util.validateRepositoryName((String)repositoryName, (String)"repositoryName");
    }

    @Nullable
    private static <T, U> List<T> convertToList(@Nullable Iterable<U> c, Function<U, T> mapper) {
        return (List)LegacyCentralDogma.convertToCollection(c, mapper, ImmutableList.toImmutableList());
    }

    @Nullable
    private static <T, U> Set<T> convertToSet(@Nullable Iterable<U> c, Function<U, T> mapper) {
        return (Set)LegacyCentralDogma.convertToCollection(c, mapper, ImmutableSet.toImmutableSet());
    }

    @Nullable
    private static <T, U, V extends Collection<T>> V convertToCollection(@Nullable Iterable<U> c, Function<U, T> mapper, Collector<T, ?, V> collector) {
        if (c == null) {
            return null;
        }
        Stream<Object> stream = c instanceof Collection ? ((Collection)c).stream() : StreamSupport.stream(c.spliterator(), false);
        return (V)((Collection)stream.map(mapper).collect(collector));
    }

    @Nullable
    private static <T, U, V, W> Map<T, U> convertToMap(@Nullable Collection<V> c, Function<V, W> entryMapper, Function<W, T> keyMapper, Function<W, U> valueMapper) {
        if (c == null) {
            return null;
        }
        return (Map)c.stream().map(entryMapper).collect(ImmutableMap.toImmutableMap(keyMapper, valueMapper));
    }

    @Nullable
    private static List<com.linecorp.centraldogma.common.Change<?>> convertToChangesModel(List<Change> changes) {
        return LegacyCentralDogma.convertToList(changes, arg_0 -> ((Converter)ChangeConverter.TO_MODEL).convert(arg_0));
    }

    private static <T> CompletableFuture<T> run(ThriftCall<T> call) {
        ThriftFuture future = new ThriftFuture();
        try {
            call.apply(future);
            return future.exceptionally(cause -> Exceptions.throwUnsafely((Throwable)LegacyCentralDogma.convertCause(cause)));
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)LegacyCentralDogma.convertCause(e));
        }
    }

    private static Throwable convertCause(Throwable cause) {
        Throwable convertedCause;
        Throwable peeledCause = Exceptions.peel((Throwable)cause);
        if (peeledCause instanceof CentralDogmaException) {
            String message = peeledCause.getMessage();
            switch (((CentralDogmaException)peeledCause).getErrorCode()) {
                case UNIMPLEMENTED: {
                    convertedCause = new com.linecorp.centraldogma.common.CentralDogmaException("unimplemented", false);
                    break;
                }
                case INTERNAL_SERVER_ERROR: {
                    convertedCause = new com.linecorp.centraldogma.common.CentralDogmaException("internal server error", false);
                    break;
                }
                case BAD_REQUEST: {
                    convertedCause = new com.linecorp.centraldogma.common.CentralDogmaException("bad request", false);
                    break;
                }
                case PROJECT_NOT_FOUND: {
                    convertedCause = new ProjectNotFoundException(message, false);
                    break;
                }
                case PROJECT_EXISTS: {
                    convertedCause = new ProjectExistsException(message, false);
                    break;
                }
                case REPOSITORY_NOT_FOUND: {
                    convertedCause = new RepositoryNotFoundException(message, false);
                    break;
                }
                case REPOSITORY_EXISTS: {
                    convertedCause = new RepositoryExistsException(message, false);
                    break;
                }
                case REVISION_NOT_FOUND: {
                    convertedCause = new RevisionNotFoundException(message, false);
                    break;
                }
                case REVISION_EXISTS: {
                    convertedCause = new ChangeConflictException(message, false);
                    break;
                }
                case ENTRY_NOT_FOUND: {
                    convertedCause = new EntryNotFoundException(message, false);
                    break;
                }
                case REDUNDANT_CHANGE: {
                    convertedCause = new RedundantChangeException(message, false);
                    break;
                }
                case CHANGE_CONFLICT: {
                    convertedCause = new ChangeConflictException(message, false);
                    break;
                }
                case QUERY_FAILURE: {
                    convertedCause = new QueryExecutionException(message, false);
                    break;
                }
                case SHUTTING_DOWN: {
                    convertedCause = new ShuttingDownException(message, false);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        } else {
            convertedCause = peeledCause;
        }
        return convertedCause;
    }

    @FunctionalInterface
    private static interface ThriftCall<T> {
        public void apply(ThriftFuture<T> var1) throws TException;
    }
}

